/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

abstract class FlinkSchemaVisitor<T> {
    FlinkSchemaVisitor() {
    }

    static <T> T visit(RowType flinkType, Schema schema, FlinkSchemaVisitor<T> visitor) {
        return FlinkSchemaVisitor.visit((LogicalType)flinkType, schema.asStruct(), visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visit(LogicalType flinkType, Type iType, FlinkSchemaVisitor<T> visitor) {
        switch (iType.typeId()) {
            case STRUCT: {
                return FlinkSchemaVisitor.visitRecord(flinkType, iType.asStructType(), visitor);
            }
            case MAP: {
                T value;
                T key;
                MapType mapType = (MapType)flinkType;
                Types.MapType iMapType = iType.asMapType();
                Types.NestedField keyField = iMapType.field(iMapType.keyId());
                visitor.beforeMapKey(keyField);
                try {
                    key = FlinkSchemaVisitor.visit(mapType.getKeyType(), iMapType.keyType(), visitor);
                }
                finally {
                    visitor.afterMapKey(keyField);
                }
                Types.NestedField valueField = iMapType.field(iMapType.valueId());
                visitor.beforeMapValue(valueField);
                try {
                    value = FlinkSchemaVisitor.visit(mapType.getValueType(), iMapType.valueType(), visitor);
                }
                finally {
                    visitor.afterMapValue(valueField);
                }
                return visitor.map(iMapType, key, value, mapType.getKeyType(), mapType.getValueType());
            }
            case LIST: {
                T element;
                ArrayType listType = (ArrayType)flinkType;
                Types.ListType iListType = iType.asListType();
                Types.NestedField elementField = iListType.field(iListType.elementId());
                visitor.beforeListElement(elementField);
                try {
                    element = FlinkSchemaVisitor.visit(listType.getElementType(), iListType.elementType(), visitor);
                }
                finally {
                    visitor.afterListElement(elementField);
                }
                return visitor.list(iListType, element, listType.getElementType());
            }
        }
        return visitor.primitive(iType.asPrimitiveType(), flinkType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitRecord(LogicalType flinkType, Types.StructType struct, FlinkSchemaVisitor<T> visitor) {
        Preconditions.checkArgument(flinkType instanceof RowType, "%s is not a RowType.", (Object)flinkType);
        RowType rowType = (RowType)flinkType;
        int fieldSize = struct.fields().size();
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(fieldSize);
        ArrayList<LogicalType> fieldTypes = Lists.newArrayListWithExpectedSize(fieldSize);
        List<Types.NestedField> nestedFields = struct.fields();
        for (int i = 0; i < fieldSize; ++i) {
            Types.NestedField iField = nestedFields.get(i);
            int fieldIndex = rowType.getFieldIndex(iField.name());
            Preconditions.checkArgument(fieldIndex >= 0, "NestedField: %s is not found in flink RowType: %s", (Object)iField, (Object)rowType);
            LogicalType fieldFlinkType = rowType.getTypeAt(fieldIndex);
            fieldTypes.add(fieldFlinkType);
            visitor.beforeField(iField);
            try {
                results.add(FlinkSchemaVisitor.visit(fieldFlinkType, iField.type(), visitor));
                continue;
            }
            finally {
                visitor.afterField(iField);
            }
        }
        return visitor.record(struct, results, fieldTypes);
    }

    public T record(Types.StructType iStruct, List<T> results, List<LogicalType> fieldTypes) {
        return null;
    }

    public T list(Types.ListType iList, T element, LogicalType elementType) {
        return null;
    }

    public T map(Types.MapType iMap, T key, T value, LogicalType keyType, LogicalType valueType) {
        return null;
    }

    public T primitive(Type.PrimitiveType iPrimitive, LogicalType flinkPrimitive) {
        return null;
    }

    public void beforeField(Types.NestedField field) {
    }

    public void afterField(Types.NestedField field) {
    }

    public void beforeListElement(Types.NestedField elementField) {
        this.beforeField(elementField);
    }

    public void afterListElement(Types.NestedField elementField) {
        this.afterField(elementField);
    }

    public void beforeMapKey(Types.NestedField keyField) {
        this.beforeField(keyField);
    }

    public void afterMapKey(Types.NestedField keyField) {
        this.afterField(keyField);
    }

    public void beforeMapValue(Types.NestedField valueField) {
        this.beforeField(valueField);
    }

    public void afterMapValue(Types.NestedField valueField) {
        this.afterField(valueField);
    }
}

