/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class StructProjection
implements StructLike {
    private final Types.StructType type;
    private final int[] positionMap;
    private final StructProjection[] nestedProjections;
    private StructLike struct;

    public static StructProjection create(Schema schema, Set<Integer> ids) {
        Types.StructType structType = schema.asStruct();
        return new StructProjection(structType, TypeUtil.select(structType, ids));
    }

    public static StructProjection create(Schema dataSchema, Schema projectedSchema) {
        return new StructProjection(dataSchema.asStruct(), projectedSchema.asStruct());
    }

    private StructProjection(Types.StructType structType, Types.StructType projection) {
        this.type = projection;
        this.positionMap = new int[projection.fields().size()];
        this.nestedProjections = new StructProjection[projection.fields().size()];
        List<Types.NestedField> dataFields = structType.fields();
        for (int pos = 0; pos < this.positionMap.length; ++pos) {
            Types.NestedField projectedField = projection.fields().get(pos);
            boolean found = false;
            block5: for (int i = 0; !found && i < dataFields.size(); ++i) {
                Types.NestedField dataField = dataFields.get(i);
                if (projectedField.fieldId() != dataField.fieldId()) continue;
                found = true;
                this.positionMap[pos] = i;
                switch (projectedField.type().typeId()) {
                    case STRUCT: {
                        this.nestedProjections[pos] = new StructProjection(dataField.type().asStructType(), projectedField.type().asStructType());
                        continue block5;
                    }
                    case MAP: 
                    case LIST: {
                        throw new IllegalArgumentException(String.format("Cannot project list or map field: %s", projectedField));
                    }
                    default: {
                        this.nestedProjections[pos] = null;
                    }
                }
            }
            if (found) continue;
            throw new IllegalArgumentException(String.format("Cannot find field %s in %s", projectedField, structType));
        }
    }

    public StructProjection wrap(StructLike newStruct) {
        this.struct = newStruct;
        return this;
    }

    @Override
    public int size() {
        return this.type.fields().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        if (this.nestedProjections[pos] != null) {
            return javaClass.cast(this.nestedProjections[pos].wrap(this.struct.get(this.positionMap[pos], StructLike.class)));
        }
        return this.struct.get(this.positionMap[pos], javaClass);
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Cannot set fields in a TypeProjection");
    }
}

