/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Comparator;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.JavaHash;
import org.apache.iceberg.types.Types;

public class StructLikeWrapper {
    private final Comparator<StructLike> comparator;
    private final JavaHash<StructLike> structHash;
    private Integer hashCode;
    private StructLike struct;

    public static StructLikeWrapper forType(Types.StructType struct) {
        return new StructLikeWrapper(struct);
    }

    private StructLikeWrapper(Types.StructType type) {
        this.comparator = Comparators.forType(type);
        this.structHash = JavaHash.forType(type);
        this.hashCode = null;
    }

    public StructLikeWrapper set(StructLike newStruct) {
        this.struct = newStruct;
        this.hashCode = null;
        return this;
    }

    public StructLike get() {
        return this.struct;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructLikeWrapper)) {
            return false;
        }
        StructLikeWrapper that = (StructLikeWrapper)other;
        if (this.struct == that.struct) {
            return true;
        }
        if (this.struct == null ^ that.struct == null) {
            return false;
        }
        return this.comparator.compare(this.struct, that.struct) == 0;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.structHash.hash(this.struct);
        }
        return this.hashCode;
    }
}

