/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.Canonicalizer;

public class EncodingList
implements Iterable<Encoding> {
    private static Canonicalizer<EncodingList> encodingLists = new Canonicalizer();
    private final List<Encoding> encodings;

    public static EncodingList getEncodingList(List<Encoding> encodings) {
        return encodingLists.canonicalize(new EncodingList(encodings));
    }

    private EncodingList(List<Encoding> encodings) {
        this.encodings = Collections.unmodifiableList(encodings);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncodingList) {
            List<Encoding> other = ((EncodingList)obj).encodings;
            int size = other.size();
            if (size != this.encodings.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (other.get(i).equals((Object)this.encodings.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (Encoding element : this.encodings) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public List<Encoding> toList() {
        return this.encodings;
    }

    @Override
    public Iterator<Encoding> iterator() {
        return this.encodings.iterator();
    }

    public int size() {
        return this.encodings.size();
    }
}

