/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.iceberg.shaded.org.apache.orc.DataMask;
import org.apache.iceberg.shaded.org.apache.orc.DataMaskDescription;
import org.apache.iceberg.shaded.org.apache.orc.OrcProto;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.jetbrains.annotations.NotNull;

public class MaskDescriptionImpl
implements DataMaskDescription,
Comparable<MaskDescriptionImpl> {
    private int id;
    private final String name;
    private final String[] parameters;
    private final Set<TypeDescription> columns = new HashSet<TypeDescription>();

    public MaskDescriptionImpl(String name, String ... parameters) {
        this.name = name;
        this.parameters = parameters == null ? new String[]{} : parameters;
    }

    public MaskDescriptionImpl(int id, OrcProto.DataMask mask) {
        this.id = id;
        this.name = mask.getName();
        this.parameters = new String[mask.getMaskParametersCount()];
        for (int p = 0; p < this.parameters.length; ++p) {
            this.parameters[p] = mask.getMaskParameters(p);
        }
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo((MaskDescriptionImpl)other) == 0;
    }

    public void addColumn(TypeDescription column) {
        this.columns.add(column);
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getParameters() {
        return this.parameters;
    }

    @Override
    public TypeDescription[] getColumns() {
        TypeDescription[] result = this.columns.toArray(new TypeDescription[this.columns.size()]);
        Arrays.sort(result, Comparator.comparingInt(TypeDescription::getId));
        return result;
    }

    public int getId() {
        return this.id;
    }

    public DataMask create(TypeDescription schema, DataMask.MaskOverrides overrides) {
        return DataMask.Factory.build(this, schema, overrides);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("mask ");
        buffer.append(this.getName());
        buffer.append('(');
        String[] parameters = this.getParameters();
        if (parameters != null) {
            for (int p = 0; p < parameters.length; ++p) {
                if (p != 0) {
                    buffer.append(", ");
                }
                buffer.append(parameters[p]);
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    public int hashCode() {
        int result = this.name.hashCode();
        for (String p : this.parameters) {
            result = result * 101 + p.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(@NotNull MaskDescriptionImpl other) {
        if (other == this) {
            return 0;
        }
        int result = this.name.compareTo(other.name);
        for (int p = 0; result == 0 && p < this.parameters.length && p < other.parameters.length; ++p) {
            result = this.parameters[p].compareTo(other.parameters[p]);
        }
        if (result == 0) {
            result = Integer.compare(this.parameters.length, other.parameters.length);
        }
        return result;
    }
}

