/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.lzo;

import java.nio.ByteBuffer;
import org.apache.iceberg.shaded.io.airlift.compress.Compressor;
import org.apache.iceberg.shaded.io.airlift.compress.lzo.LzoRawCompressor;
import org.apache.iceberg.shaded.io.airlift.compress.lzo.UnsafeUtil;
import sun.misc.Unsafe;

public class LzoCompressor
implements Compressor {
    private final int[] table = new int[4096];

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return LzoRawCompressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        return LzoRawCompressor.compress(input, inputAddress, inputLength, output, outputAddress, maxOutputLength, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(ByteBuffer input, ByteBuffer output) {
        long outputLimit;
        long outputAddress;
        byte[] outputBase;
        long inputLimit;
        long inputAddress;
        byte[] inputBase;
        if (input.isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (input.hasArray()) {
            inputBase = input.array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (output.isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output);
            outputAddress = address + (long)output.position();
            outputLimit = address + (long)output.limit();
        } else if (output.hasArray()) {
            outputBase = output.array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = LzoRawCompressor.compress(inputBase, inputAddress, (int)(inputLimit - inputAddress), outputBase, outputAddress, outputLimit - outputAddress, this.table);
                output.position(output.position() + written);
            }
        }
    }
}

