/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.ImmutableIcebergTable;
import java.util.Map;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.UpdateableReference;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private final NessieClient client;
    private final ContentsKey key;
    private UpdateableReference reference;
    private IcebergTable table;
    private FileIO fileIO;

    public NessieTableOperations(ContentsKey key, UpdateableReference reference, NessieClient client, FileIO fileIO) {
        this.key = key;
        this.reference = reference;
        this.client = client;
        this.fileIO = fileIO;
    }

    @Override
    protected void doRefresh() {
        String metadataLocation;
        block4: {
            try {
                this.reference.refresh();
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException("Failed to refresh as ref is no longer valid.", e);
            }
            metadataLocation = null;
            try {
                Contents contents = this.client.getContentsApi().getContents(this.key, this.reference.getHash());
                this.table = contents.unwrap(IcebergTable.class).orElseThrow(() -> new IllegalStateException("Cannot refresh iceberg table: " + String.format("Nessie points to a non-Iceberg object for path: %s.", this.key)));
                metadataLocation = this.table.getMetadataLocation();
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block4;
                throw new NoSuchTableException(ex, "No such table %s", this.key);
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, 2);
    }

    @Override
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        this.reference.checkMutable();
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        boolean threw = true;
        try {
            ImmutableIcebergTable newTable = ImmutableIcebergTable.builder().metadataLocation(newMetadataLocation).build();
            this.client.getContentsApi().setContents(this.key, this.reference.getAsBranch().getName(), this.reference.getHash(), String.format("iceberg commit%s", this.applicationId()), newTable);
            threw = false;
        }
        catch (NessieConflictException ex) {
            throw new CommitFailedException(ex, "Commit failed: Reference hash is out of date. Update the reference %s and try again", this.reference.getName());
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(String.format("Commit failed: Reference %s no longer exist", this.reference.getName()), ex);
        }
        finally {
            if (threw) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }

    private String applicationId() {
        Snapshot snapshot;
        String appId = null;
        TableMetadata current = this.current();
        if (current != null && (snapshot = current.currentSnapshot()) != null) {
            Map<String, String> summary = snapshot.summary();
            appId = summary.get("spark.app.id");
        }
        return appId == null ? "" : "\nspark.app.id= " + appId;
    }
}

