/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import org.apache.iceberg.StructLike;

class StructCopy
implements StructLike {
    private final Object[] values;

    static StructLike copy(StructLike struct) {
        return new StructCopy(struct);
    }

    private StructCopy(StructLike toCopy) {
        this.values = new Object[toCopy.size()];
        for (int i = 0; i < this.values.length; ++i) {
            Object value = toCopy.get(i, Object.class);
            this.values[i] = value instanceof StructLike ? StructCopy.copy((StructLike)value) : value;
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.values[pos]);
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Struct copy cannot be modified");
    }
}

