/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.sink.IcebergFilesCommitter;
import org.apache.iceberg.flink.sink.IcebergStreamWriter;
import org.apache.iceberg.flink.sink.PartitionKeySelector;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkSink {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkSink.class);
    private static final String ICEBERG_STREAM_WRITER_NAME = IcebergStreamWriter.class.getSimpleName();
    private static final String ICEBERG_FILES_COMMITTER_NAME = IcebergFilesCommitter.class.getSimpleName();

    private FlinkSink() {
    }

    public static <T> Builder builderFor(DataStream<T> input, MapFunction<T, RowData> mapper, TypeInformation<RowData> outputType) {
        SingleOutputStreamOperator dataStream = input.map(mapper, outputType);
        return FlinkSink.forRowData((DataStream<RowData>)dataStream);
    }

    public static Builder forRow(DataStream<Row> input, TableSchema tableSchema) {
        RowType rowType = (RowType)tableSchema.toRowDataType().getLogicalType();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        DataFormatConverters.RowConverter rowConverter = new DataFormatConverters.RowConverter(fieldDataTypes);
        return FlinkSink.builderFor(input, arg_0 -> ((DataFormatConverters.RowConverter)rowConverter).toInternal(arg_0), (TypeInformation<RowData>)RowDataTypeInfo.of((RowType)rowType)).tableSchema(tableSchema);
    }

    public static Builder forRowData(DataStream<RowData> input) {
        return new Builder().forRowData((DataStream<RowData>)input);
    }

    static RowType toFlinkRowType(Schema schema, TableSchema requestedSchema) {
        if (requestedSchema != null) {
            Schema writeSchema = TypeUtil.reassignIds(FlinkSchemaUtil.convert(requestedSchema), schema);
            TypeUtil.validateWriteSchema(schema, writeSchema, true, true);
            return (RowType)requestedSchema.toRowDataType().getLogicalType();
        }
        return FlinkSchemaUtil.convert(schema);
    }

    static IcebergStreamWriter<RowData> createStreamWriter(Table table, RowType flinkRowType, List<Integer> equalityFieldIds) {
        Map<String, String> props = table.properties();
        long targetFileSize = FlinkSink.getTargetFileSizeBytes(props);
        FileFormat fileFormat = FlinkSink.getFileFormat(props);
        RowDataTaskWriterFactory taskWriterFactory = new RowDataTaskWriterFactory(table.schema(), flinkRowType, table.spec(), table.locationProvider(), table.io(), table.encryption(), targetFileSize, fileFormat, props, equalityFieldIds);
        return new IcebergStreamWriter<RowData>(table.name(), taskWriterFactory);
    }

    private static FileFormat getFileFormat(Map<String, String> properties) {
        String formatString = properties.getOrDefault("write.format.default", "parquet");
        return FileFormat.valueOf(formatString.toUpperCase(Locale.ENGLISH));
    }

    private static long getTargetFileSizeBytes(Map<String, String> properties) {
        return PropertyUtil.propertyAsLong(properties, "write.target-file-size-bytes", Long.MAX_VALUE);
    }

    public static class Builder {
        private DataStream<RowData> rowDataInput = null;
        private TableLoader tableLoader;
        private Table table;
        private TableSchema tableSchema;
        private boolean overwrite = false;
        private DistributionMode distributionMode = null;
        private Integer writeParallelism = null;
        private List<String> equalityFieldColumns = null;

        private Builder() {
        }

        private Builder forRowData(DataStream<RowData> newRowDataInput) {
            this.rowDataInput = newRowDataInput;
            return this;
        }

        public Builder table(Table newTable) {
            this.table = newTable;
            return this;
        }

        public Builder tableLoader(TableLoader newTableLoader) {
            this.tableLoader = newTableLoader;
            return this;
        }

        public Builder tableSchema(TableSchema newTableSchema) {
            this.tableSchema = newTableSchema;
            return this;
        }

        public Builder overwrite(boolean newOverwrite) {
            this.overwrite = newOverwrite;
            return this;
        }

        public Builder distributionMode(DistributionMode mode) {
            Preconditions.checkArgument(!DistributionMode.RANGE.equals((Object)mode), "Flink does not support 'range' write distribution mode now.");
            this.distributionMode = mode;
            return this;
        }

        public Builder writeParallelism(int newWriteParallelism) {
            this.writeParallelism = newWriteParallelism;
            return this;
        }

        public Builder equalityFieldColumns(List<String> columns) {
            this.equalityFieldColumns = columns;
            return this;
        }

        public DataStreamSink<RowData> build() {
            Preconditions.checkArgument(this.rowDataInput != null, "Please use forRowData() to initialize the input DataStream.");
            Preconditions.checkNotNull(this.tableLoader, "Table loader shouldn't be null");
            if (this.table == null) {
                this.tableLoader.open();
                try {
                    TableLoader loader = this.tableLoader;
                    Object object = null;
                    try {
                        this.table = loader.loadTable();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (loader != null) {
                            if (object != null) {
                                try {
                                    loader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                loader.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to load iceberg table from table loader: " + this.tableLoader, e);
                }
            }
            ArrayList<Integer> equalityFieldIds = Lists.newArrayList();
            if (this.equalityFieldColumns != null && this.equalityFieldColumns.size() > 0) {
                for (String column : this.equalityFieldColumns) {
                    Types.NestedField field = this.table.schema().findField(column);
                    Preconditions.checkNotNull(field, "Missing required equality field column '%s' in table schema %s", (Object)column, (Object)this.table.schema());
                    equalityFieldIds.add(field.fieldId());
                }
            }
            RowType flinkRowType = FlinkSink.toFlinkRowType(this.table.schema(), this.tableSchema);
            this.rowDataInput = this.distributeDataStream(this.rowDataInput, this.table.properties(), this.table.spec(), this.table.schema(), flinkRowType);
            IcebergStreamWriter<RowData> streamWriter = FlinkSink.createStreamWriter(this.table, flinkRowType, equalityFieldIds);
            IcebergFilesCommitter filesCommitter = new IcebergFilesCommitter(this.tableLoader, this.overwrite);
            this.writeParallelism = this.writeParallelism == null ? this.rowDataInput.getParallelism() : this.writeParallelism.intValue();
            SingleOutputStreamOperator returnStream = this.rowDataInput.transform(ICEBERG_STREAM_WRITER_NAME, TypeInformation.of(WriteResult.class), streamWriter).setParallelism(this.writeParallelism.intValue()).transform(ICEBERG_FILES_COMMITTER_NAME, Types.VOID, (OneInputStreamOperator)filesCommitter).setParallelism(1).setMaxParallelism(1);
            return returnStream.addSink((SinkFunction)new DiscardingSink()).name(String.format("IcebergSink %s", this.table.name())).setParallelism(1);
        }

        private DataStream<RowData> distributeDataStream(DataStream<RowData> input, Map<String, String> properties, PartitionSpec partitionSpec, Schema iSchema, RowType flinkRowType) {
            DistributionMode writeMode;
            if (this.distributionMode == null) {
                String modeName = PropertyUtil.propertyAsString(properties, "write.distribution-mode", "none");
                writeMode = DistributionMode.fromName(modeName);
            } else {
                writeMode = this.distributionMode;
            }
            switch (writeMode) {
                case NONE: {
                    return input;
                }
                case HASH: {
                    if (partitionSpec.isUnpartitioned()) {
                        return input;
                    }
                    return input.keyBy((KeySelector)new PartitionKeySelector(partitionSpec, iSchema, flinkRowType));
                }
                case RANGE: {
                    LOG.warn("Fallback to use 'none' distribution mode, because {}={} is not supported in flink now", (Object)"write.distribution-mode", (Object)DistributionMode.RANGE.modeName());
                    return input;
                }
            }
            throw new RuntimeException("Unrecognized write.distribution-mode: " + (Object)((Object)writeMode));
        }
    }
}

