/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.avro.AvroWithPartnerByStructureVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.Pair;

public abstract class AvroWithFlinkSchemaVisitor<T>
extends AvroWithPartnerByStructureVisitor<LogicalType, T> {
    @Override
    protected boolean isStringType(LogicalType logicalType) {
        return logicalType.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING);
    }

    @Override
    protected boolean isMapType(LogicalType logicalType) {
        return logicalType instanceof MapType;
    }

    @Override
    protected LogicalType arrayElementType(LogicalType arrayType) {
        Preconditions.checkArgument(arrayType instanceof ArrayType, "Invalid array: %s is not an array", (Object)arrayType);
        return ((ArrayType)arrayType).getElementType();
    }

    @Override
    protected LogicalType mapKeyType(LogicalType mapType) {
        Preconditions.checkArgument(this.isMapType(mapType), "Invalid map: %s is not a map", (Object)mapType);
        return ((MapType)mapType).getKeyType();
    }

    @Override
    protected LogicalType mapValueType(LogicalType mapType) {
        Preconditions.checkArgument(this.isMapType(mapType), "Invalid map: %s is not a map", (Object)mapType);
        return ((MapType)mapType).getValueType();
    }

    @Override
    protected Pair<String, LogicalType> fieldNameAndType(LogicalType structType, int pos) {
        Preconditions.checkArgument(structType instanceof RowType, "Invalid struct: %s is not a struct", (Object)structType);
        RowType.RowField field = (RowType.RowField)((RowType)structType).getFields().get(pos);
        return Pair.of(field.getName(), field.getType());
    }

    @Override
    protected LogicalType nullType() {
        return new NullType();
    }
}

