/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.LimitableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.iceberg.flink.FlinkFilters;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class IcebergTableSource
implements StreamTableSource<RowData>,
ProjectableTableSource<RowData>,
FilterableTableSource<RowData>,
LimitableTableSource<RowData> {
    private static final Joiner COMMA = Joiner.on(',');
    private final TableLoader loader;
    private final TableSchema schema;
    private final Map<String, String> properties;
    private final int[] projectedFields;
    private final boolean isLimitPushDown;
    private final long limit;
    private final List<org.apache.iceberg.expressions.Expression> filters;
    private final ReadableConfig readableConfig;

    public IcebergTableSource(TableLoader loader, TableSchema schema, Map<String, String> properties, ReadableConfig readableConfig) {
        this(loader, schema, properties, null, false, -1L, ImmutableList.of(), readableConfig);
    }

    private IcebergTableSource(TableLoader loader, TableSchema schema, Map<String, String> properties, int[] projectedFields, boolean isLimitPushDown, long limit, List<org.apache.iceberg.expressions.Expression> filters, ReadableConfig readableConfig) {
        this.loader = loader;
        this.schema = schema;
        this.properties = properties;
        this.projectedFields = projectedFields;
        this.isLimitPushDown = isLimitPushDown;
        this.limit = limit;
        this.filters = filters;
        this.readableConfig = readableConfig;
    }

    public boolean isBounded() {
        return FlinkSource.isBounded(this.properties);
    }

    public TableSource<RowData> projectFields(int[] fields) {
        return new IcebergTableSource(this.loader, this.schema, this.properties, fields, this.isLimitPushDown, this.limit, this.filters, this.readableConfig);
    }

    public DataStream<RowData> getDataStream(StreamExecutionEnvironment execEnv) {
        return FlinkSource.forRowData().env(execEnv).tableLoader(this.loader).properties(this.properties).project(this.getProjectedSchema()).limit(this.limit).filters(this.filters).flinkConf(this.readableConfig).build();
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public DataType getProducedDataType() {
        return (DataType)this.getProjectedSchema().toRowDataType().bridgedTo(RowData.class);
    }

    private TableSchema getProjectedSchema() {
        TableSchema fullSchema = this.getTableSchema();
        if (this.projectedFields == null) {
            return fullSchema;
        }
        String[] fullNames = fullSchema.getFieldNames();
        DataType[] fullTypes = fullSchema.getFieldDataTypes();
        return TableSchema.builder().fields((String[])Arrays.stream(this.projectedFields).mapToObj(i -> fullNames[i]).toArray(String[]::new), (DataType[])Arrays.stream(this.projectedFields).mapToObj(i -> fullTypes[i]).toArray(DataType[]::new)).build();
    }

    public String explainSource() {
        String explain = "Iceberg table: " + this.loader.toString();
        if (this.projectedFields != null) {
            explain = explain + ", ProjectedFields: " + Arrays.toString(this.projectedFields);
        }
        if (this.isLimitPushDown) {
            explain = explain + String.format(", LimitPushDown : %d", this.limit);
        }
        if (this.isFilterPushedDown()) {
            explain = explain + String.format(", FilterPushDown: %s", COMMA.join(this.filters));
        }
        return TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.getTableSchema().getFieldNames()) + explain;
    }

    public boolean isLimitPushedDown() {
        return this.isLimitPushDown;
    }

    public TableSource<RowData> applyLimit(long newLimit) {
        return new IcebergTableSource(this.loader, this.schema, this.properties, this.projectedFields, true, newLimit, this.filters, this.readableConfig);
    }

    public TableSource<RowData> applyPredicate(List<Expression> predicates) {
        ArrayList<org.apache.iceberg.expressions.Expression> expressions = Lists.newArrayList();
        for (Expression predicate : predicates) {
            FlinkFilters.convert(predicate).ifPresent(expressions::add);
        }
        return new IcebergTableSource(this.loader, this.schema, this.properties, this.projectedFields, this.isLimitPushDown, this.limit, expressions, this.readableConfig);
    }

    public boolean isFilterPushedDown() {
        return this.filters != null && this.filters.size() > 0;
    }
}

