/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.util.Arrays;
import java.util.Objects;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;

public class TableIdentifier {
    private static final Splitter DOT = Splitter.on('.');
    private final Namespace namespace;
    private final String name;

    public static TableIdentifier of(String ... names) {
        Preconditions.checkArgument(names.length > 0, "Cannot create table identifier without a table name");
        return new TableIdentifier(Namespace.of(Arrays.copyOf(names, names.length - 1)), names[names.length - 1]);
    }

    public static TableIdentifier of(Namespace namespace, String name) {
        return new TableIdentifier(namespace, name);
    }

    public static TableIdentifier parse(String identifier) {
        Iterable<String> parts = DOT.split(identifier);
        return TableIdentifier.of(Iterables.toArray(parts, String.class));
    }

    private TableIdentifier(Namespace namespace, String name) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "Invalid table name %s", (Object)name);
        this.namespace = namespace;
        this.name = name;
    }

    public boolean hasNamespace() {
        return !this.namespace.isEmpty();
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public TableIdentifier toLowerCase() {
        String[] newLevels = (String[])Arrays.stream(this.namespace().levels()).map(String::toLowerCase).toArray(String[]::new);
        String newName = this.name().toLowerCase();
        return TableIdentifier.of(Namespace.of(newLevels), newName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TableIdentifier that = (TableIdentifier)other;
        return this.namespace.equals(that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    public String toString() {
        if (this.hasNamespace()) {
            return this.namespace.toString() + "." + this.name;
        }
        return this.name;
    }
}

