/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import software.amazon.awssdk.services.s3.S3Client;

public class S3OutputFile
extends BaseS3File
implements OutputFile {
    public S3OutputFile(S3Client client, S3URI uri) {
        this(client, uri, new AwsProperties());
    }

    public S3OutputFile(S3Client client, S3URI uri, AwsProperties awsProperties) {
        super(client, uri, awsProperties);
    }

    @Override
    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", this.uri());
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        try {
            return new S3OutputStream(this.client(), this.uri(), this.awsProperties());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Filed to create output stream for location: " + this.uri(), e);
        }
    }

    @Override
    public InputFile toInputFile() {
        return new S3InputFile(this.client(), this.uri(), this.awsProperties());
    }
}

