/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.common.DynConstructors;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class AwsClientFactories {
    private static final SdkHttpClient HTTP_CLIENT_DEFAULT = UrlConnectionHttpClient.create();
    private static final DefaultAwsClientFactory AWS_CLIENT_FACTORY_DEFAULT = new DefaultAwsClientFactory();

    private AwsClientFactories() {
    }

    public static AwsClientFactory defaultFactory() {
        return AWS_CLIENT_FACTORY_DEFAULT;
    }

    public static AwsClientFactory from(Map<String, String> properties) {
        if (properties.containsKey("client.factory")) {
            return AwsClientFactories.loadClientFactory(properties.get("client.factory"), properties);
        }
        return AwsClientFactories.defaultFactory();
    }

    private static AwsClientFactory loadClientFactory(String impl, Map<String, String> properties) {
        AwsClientFactory factory;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(AwsClientFactory.class).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AwsClientFactory, missing no-arg constructor: %s", impl), e);
        }
        try {
            factory = (AwsClientFactory)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AwsClientFactory, %s does not implement AwsClientFactory.", impl), e);
        }
        factory.initialize(properties);
        return factory;
    }

    static class DefaultAwsClientFactory
    implements AwsClientFactory {
        DefaultAwsClientFactory() {
        }

        @Override
        public S3Client s3() {
            return (S3Client)((S3ClientBuilder)S3Client.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public GlueClient glue() {
            return (GlueClient)((GlueClientBuilder)GlueClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public KmsClient kms() {
            return (KmsClient)((KmsClientBuilder)KmsClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public DynamoDbClient dynamo() {
            return (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public void initialize(Map<String, String> properties) {
        }
    }
}

