/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.function.Function;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;

class StaticTableScan
extends BaseTableScan {
    private final Function<StaticTableScan, DataTask> buildTask;

    StaticTableScan(TableOperations ops, Table table, Schema schema, Function<StaticTableScan, DataTask> buildTask) {
        super(ops, table, schema);
        this.buildTask = buildTask;
    }

    private StaticTableScan(TableOperations ops, Table table, Schema schema, Function<StaticTableScan, DataTask> buildTask, TableScanContext context) {
        super(ops, table, schema, context);
        this.buildTask = buildTask;
    }

    @Override
    protected long targetSplitSize(TableOperations ops) {
        return ops.current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        return new StaticTableScan(ops, table, schema, this.buildTask, context);
    }

    @Override
    protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
        return CloseableIterable.withNoopClose((FileScanTask)this.buildTask.apply(this));
    }
}

