/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class StaticDataTask
implements DataTask {
    private final DataFile metadataFile;
    private final StructLike[] rows;

    static <T> DataTask of(InputFile metadata, Iterable<T> values, Function<T, Row> transform) {
        return new StaticDataTask(metadata, Lists.newArrayList(Iterables.transform(values, transform::apply)).toArray(new Row[0]));
    }

    private StaticDataTask(InputFile metadata, StructLike[] rows) {
        this.metadataFile = DataFiles.builder(PartitionSpec.unpartitioned()).withInputFile(metadata).withRecordCount(rows.length).withFormat(FileFormat.METADATA).build();
        this.rows = rows;
    }

    @Override
    public List<DeleteFile> deletes() {
        return ImmutableList.of();
    }

    @Override
    public CloseableIterable<StructLike> rows() {
        return CloseableIterable.withNoopClose(Arrays.asList(this.rows));
    }

    @Override
    public DataFile file() {
        return this.metadataFile;
    }

    @Override
    public PartitionSpec spec() {
        return PartitionSpec.unpartitioned();
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    public long length() {
        return this.metadataFile.fileSizeInBytes();
    }

    @Override
    public Expression residual() {
        return Expressions.alwaysTrue();
    }

    @Override
    public Iterable<FileScanTask> split(long splitSize) {
        return ImmutableList.of(this);
    }

    static class Row
    implements StructLike,
    Serializable {
        private final Object[] values;

        public static Row of(Object ... values) {
            return new Row(values);
        }

        private Row(Object ... values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        @Override
        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Setting values is not supported");
        }
    }
}

