/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class PartitionsTable
extends BaseMetadataTable {
    private final TableOperations ops;
    private final Table table;
    private final Schema schema;
    private final String name;

    PartitionsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".partitions");
    }

    PartitionsTable(TableOperations ops, Table table, String name) {
        this.ops = ops;
        this.table = table;
        this.schema = new Schema(Types.NestedField.required(1, "partition", table.spec().partitionType()), Types.NestedField.required(2, "record_count", Types.LongType.get()), Types.NestedField.required(3, "file_count", Types.IntegerType.get()));
        this.name = name;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TableScan newScan() {
        return new PartitionsScan();
    }

    @Override
    public Schema schema() {
        if (this.table.spec().fields().size() < 1) {
            return this.schema.select("record_count", "file_count");
        }
        return this.schema;
    }

    @Override
    String metadataLocation() {
        return this.ops.current().metadataFileLocation();
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.PARTITIONS;
    }

    private DataTask task(TableScan scan) {
        Iterable<Partition> partitions = PartitionsTable.partitions(this.table, scan.snapshot().snapshotId());
        if (this.table.spec().fields().size() < 1) {
            return StaticDataTask.of(this.io().newInputFile(this.ops.current().metadataFileLocation()), partitions, root -> StaticDataTask.Row.of(((Partition)root).recordCount, ((Partition)root).fileCount));
        }
        return StaticDataTask.of(this.io().newInputFile(this.ops.current().metadataFileLocation()), partitions, PartitionsTable::convertPartition);
    }

    private static StaticDataTask.Row convertPartition(Partition partition) {
        return StaticDataTask.Row.of(partition.key, partition.recordCount, partition.fileCount);
    }

    private static Iterable<Partition> partitions(Table table, Long snapshotId) {
        PartitionMap partitions = new PartitionMap(table.spec().partitionType());
        TableScan scan = table.newScan();
        if (snapshotId != null) {
            scan = scan.useSnapshot(snapshotId);
        }
        for (FileScanTask task : scan.planFiles()) {
            partitions.get(task.file().partition()).update(task.file());
        }
        return partitions.all();
    }

    static class Partition {
        private final StructLike key;
        private long recordCount;
        private int fileCount;

        Partition(StructLike key) {
            this.key = key;
            this.recordCount = 0L;
            this.fileCount = 0;
        }

        void update(DataFile file) {
            this.recordCount += file.recordCount();
            ++this.fileCount;
        }
    }

    static class PartitionMap {
        private final Map<StructLikeWrapper, Partition> partitions = Maps.newHashMap();
        private final Types.StructType type;
        private final StructLikeWrapper reused;

        PartitionMap(Types.StructType type) {
            this.type = type;
            this.reused = StructLikeWrapper.forType(type);
        }

        Partition get(StructLike key) {
            Partition partition = this.partitions.get(this.reused.set(key));
            if (partition == null) {
                partition = new Partition(key);
                this.partitions.put(StructLikeWrapper.forType(this.type).set(key), partition);
            }
            return partition;
        }

        Iterable<Partition> all() {
            return this.partitions.values();
        }
    }

    private class PartitionsScan
    extends StaticTableScan {
        PartitionsScan() {
            super(PartitionsTable.this.ops, PartitionsTable.this.table, PartitionsTable.this.schema(), (StaticTableScan x$0) -> PartitionsTable.this.task(x$0));
        }
    }
}

