/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class MetricsUtil {
    private MetricsUtil() {
    }

    public static Map<Integer, Long> createNanValueCounts(Stream<FieldMetrics> fieldMetrics, MetricsConfig metricsConfig, Schema inputSchema) {
        Preconditions.checkNotNull(metricsConfig, "metricsConfig is required");
        if (fieldMetrics == null || inputSchema == null) {
            return Maps.newHashMap();
        }
        return fieldMetrics.filter(metrics -> MetricsUtil.metricsMode(inputSchema, metricsConfig, metrics.id()) != MetricsModes.None.get()).collect(Collectors.toMap(FieldMetrics::id, FieldMetrics::nanValueCount));
    }

    public static MetricsModes.MetricsMode metricsMode(Schema inputSchema, MetricsConfig metricsConfig, int fieldId) {
        Preconditions.checkNotNull(inputSchema, "inputSchema is required");
        Preconditions.checkNotNull(metricsConfig, "metricsConfig is required");
        String columnName = inputSchema.findColumnName(fieldId);
        return metricsConfig.columnMode(columnName);
    }
}

