/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class ManifestEntriesTable
extends BaseMetadataTable {
    private final TableOperations ops;
    private final Table table;
    private final String name;

    ManifestEntriesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".entries");
    }

    ManifestEntriesTable(TableOperations ops, Table table, String name) {
        this.ops = ops;
        this.table = table;
        this.name = name;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TableScan newScan() {
        return new EntriesTableScan(this.ops, this.table, this.schema());
    }

    @Override
    public Schema schema() {
        Schema schema = ManifestEntry.getSchema(this.table.spec().partitionType());
        if (this.table.spec().fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    @Override
    String metadataLocation() {
        return this.ops.current().metadataFileLocation();
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ENTRIES;
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema fileSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        ManifestReadTask(FileIO io, ManifestFile manifest, Schema fileSchema, String schemaString, String specString, ResidualEvaluator residuals, Map<Integer, PartitionSpec> specsById) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.fileSchema = fileSchema;
            this.io = io;
            this.manifest = manifest;
            this.specsById = specsById;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            if (this.manifest.content() == ManifestContent.DATA) {
                return CloseableIterable.transform(ManifestFiles.read(this.manifest, this.io).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file);
            }
            return CloseableIterable.transform(ManifestFiles.readDeleteManifest(this.manifest, this.io, this.specsById).project(this.fileSchema).entries(), file -> (GenericManifestEntry)file);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }

    private static class EntriesTableScan
    extends BaseTableScan {
        EntriesTableScan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema);
        }

        private EntriesTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new EntriesTableScan(ops, table, schema, context);
        }

        @Override
        protected long targetSplitSize(TableOperations ops) {
            return ops.current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            CloseableIterable<ManifestFile> manifests = CloseableIterable.withNoopClose(snapshot.allManifests());
            Type fileProjection = this.schema().findType("data_file");
            Schema fileSchema = fileProjection != null ? new Schema(fileProjection.asStructType().fields()) : new Schema(new Types.NestedField[0]);
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
            return CloseableIterable.transform(manifests, manifest -> new ManifestReadTask(ops.io(), (ManifestFile)manifest, fileSchema, schemaString, specString, residuals, ops.current().specsById()));
        }
    }
}

