/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.TableScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseTableScan
implements TableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTableScan.class);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final TableOperations ops;
    private final Table table;
    private final Schema schema;
    private final TableScanContext context;

    protected BaseTableScan(TableOperations ops, Table table, Schema schema) {
        this(ops, table, schema, new TableScanContext());
    }

    protected BaseTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        this.ops = ops;
        this.table = table;
        this.schema = schema;
        this.context = context;
    }

    protected TableOperations tableOps() {
        return this.ops;
    }

    protected Long snapshotId() {
        return this.context.snapshotId();
    }

    protected boolean colStats() {
        return this.context.returnColumnStats();
    }

    protected boolean shouldIgnoreResiduals() {
        return this.context.ignoreResiduals();
    }

    protected Collection<String> selectedColumns() {
        return this.context.selectedColumns();
    }

    protected Map<String, String> options() {
        return this.context.options();
    }

    protected TableScanContext context() {
        return this.context;
    }

    protected abstract long targetSplitSize(TableOperations var1);

    protected abstract TableScan newRefinedScan(TableOperations var1, Table var2, Schema var3, TableScanContext var4);

    protected abstract CloseableIterable<FileScanTask> planFiles(TableOperations var1, Snapshot var2, Expression var3, boolean var4, boolean var5, boolean var6);

    @Override
    public Table table() {
        return this.table;
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        Preconditions.checkArgument(this.context.snapshotId() == null, "Cannot override snapshot, already set to id=%s", (Object)this.context.snapshotId());
        Preconditions.checkArgument(this.ops.current().snapshot(scanSnapshotId) != null, "Cannot find snapshot with ID %s", scanSnapshotId);
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.useSnapshotId(scanSnapshotId));
    }

    @Override
    public TableScan asOfTime(long timestampMillis) {
        Preconditions.checkArgument(this.context.snapshotId() == null, "Cannot override snapshot, already set to id=%s", (Object)this.context.snapshotId());
        Long lastSnapshotId = null;
        for (HistoryEntry logEntry : this.ops.current().snapshotLog()) {
            if (logEntry.timestampMillis() > timestampMillis) continue;
            lastSnapshotId = logEntry.snapshotId();
        }
        Preconditions.checkArgument(lastSnapshotId != null, "Cannot find a snapshot older than %s", (Object)BaseTableScan.formatTimestampMillis(timestampMillis));
        return this.useSnapshot(lastSnapshotId);
    }

    @Override
    public TableScan option(String property, String value) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.withOption(property, value));
    }

    @Override
    public TableScan project(Schema projectedSchema) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.project(projectedSchema));
    }

    @Override
    public TableScan caseSensitive(boolean scanCaseSensitive) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.setCaseSensitive(scanCaseSensitive));
    }

    @Override
    public TableScan includeColumnStats() {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.shouldReturnColumnStats(true));
    }

    @Override
    public TableScan select(Collection<String> columns) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.selectColumns(columns));
    }

    @Override
    public TableScan filter(Expression expr) {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.filterRows(Expressions.and(this.context.rowFilter(), expr)));
    }

    @Override
    public Expression filter() {
        return this.context.rowFilter();
    }

    @Override
    public TableScan ignoreResiduals() {
        return this.newRefinedScan(this.ops, this.table, this.schema, this.context.ignoreResiduals(true));
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        Snapshot snapshot = this.snapshot();
        if (snapshot != null) {
            LOG.info("Scanning table {} snapshot {} created at {} with filter {}", new Object[]{this.table, snapshot.snapshotId(), BaseTableScan.formatTimestampMillis(snapshot.timestampMillis()), this.context.rowFilter()});
            Listeners.notifyAll(new ScanEvent(this.table.name(), snapshot.snapshotId(), this.context.rowFilter(), this.schema()));
            return this.planFiles(this.ops, snapshot, this.context.rowFilter(), this.context.ignoreResiduals(), this.context.caseSensitive(), this.context.returnColumnStats());
        }
        LOG.info("Scanning empty table {}", (Object)this.table);
        return CloseableIterable.empty();
    }

    @Override
    public CloseableIterable<CombinedScanTask> planTasks() {
        Map<String, String> options = this.context.options();
        long splitSize = options.containsKey("read.split.target-size") ? Long.parseLong(options.get("read.split.target-size")) : this.targetSplitSize(this.ops);
        int lookback = options.containsKey("read.split.planning-lookback") ? Integer.parseInt(options.get("read.split.planning-lookback")) : this.ops.current().propertyAsInt("read.split.planning-lookback", 10);
        long openFileCost = options.containsKey("read.split.open-file-cost") ? Long.parseLong(options.get("read.split.open-file-cost")) : this.ops.current().propertyAsLong("read.split.open-file-cost", 0x400000L);
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, splitSize);
        return TableScanUtil.planTasks(splitFiles, splitSize, lookback, openFileCost);
    }

    @Override
    public Schema schema() {
        return this.lazyColumnProjection();
    }

    @Override
    public Snapshot snapshot() {
        return this.context.snapshotId() != null ? this.ops.current().snapshot(this.context.snapshotId()) : this.ops.current().currentSnapshot();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.context.caseSensitive();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("table", this.table).add("projection", this.schema().asStruct()).add("filter", this.context.rowFilter()).add("ignoreResiduals", this.context.ignoreResiduals()).add("caseSensitive", this.context.caseSensitive()).toString();
    }

    private Schema lazyColumnProjection() {
        Collection<String> selectedColumns = this.context.selectedColumns();
        if (selectedColumns != null) {
            HashSet<Integer> requiredFieldIds = Sets.newHashSet();
            requiredFieldIds.addAll(Binder.boundReferences(this.schema.asStruct(), Collections.singletonList(this.context.rowFilter()), this.context.caseSensitive()));
            Set<Integer> selectedIds = this.context.caseSensitive() ? TypeUtil.getProjectedIds(this.schema.select(selectedColumns)) : TypeUtil.getProjectedIds(this.schema.caseInsensitiveSelect(selectedColumns));
            requiredFieldIds.addAll(selectedIds);
            return TypeUtil.select(this.schema, requiredFieldIds);
        }
        if (this.context.projectedSchema() != null) {
            return this.context.projectedSchema();
        }
        return this.schema;
    }

    private static String formatTimestampMillis(long millis) {
        return DATE_FORMAT.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()));
    }
}

