/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreTableOperations
implements TableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreTableOperations.class);
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String ICEBERG_TABLE_TYPE_VALUE = "iceberg";
    public static final String METADATA_LOCATION_PROP = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION_PROP = "previous_metadata_location";
    private static final String METADATA_FOLDER_NAME = "metadata";
    private TableMetadata currentMetadata = null;
    private String currentMetadataLocation = null;
    private boolean shouldRefresh = true;
    private int version = -1;

    protected BaseMetastoreTableOperations() {
    }

    protected String tableName() {
        return null;
    }

    @Override
    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    public String currentMetadataLocation() {
        return this.currentMetadataLocation;
    }

    public int currentVersion() {
        return this.version;
    }

    @Override
    public TableMetadata refresh() {
        boolean currentMetadataWasAvailable = this.currentMetadata != null;
        try {
            this.doRefresh();
        }
        catch (NoSuchTableException e) {
            if (currentMetadataWasAvailable) {
                LOG.warn("Could not find the table during refresh, setting current metadata to null", (Throwable)e);
                this.shouldRefresh = true;
            }
            this.currentMetadata = null;
            this.currentMetadataLocation = null;
            this.version = -1;
            throw e;
        }
        return this.current();
    }

    protected void doRefresh() {
        throw new UnsupportedOperationException("Not implemented: doRefresh");
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        if (base != this.current()) {
            throw new CommitFailedException("Cannot commit: stale table metadata", new Object[0]);
        }
        if (base == metadata) {
            LOG.info("Nothing to commit.");
            return;
        }
        long start = System.currentTimeMillis();
        this.doCommit(base, metadata);
        this.deleteRemovedMetadataFiles(base, metadata);
        this.requestRefresh();
        LOG.info("Successfully committed to table {} in {} ms", (Object)this.tableName(), (Object)(System.currentTimeMillis() - start));
    }

    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        throw new UnsupportedOperationException("Not implemented: doCommit");
    }

    protected void requestRefresh() {
        this.shouldRefresh = true;
    }

    protected String writeNewMetadata(TableMetadata metadata, int newVersion) {
        String newTableMetadataFilePath = this.newTableMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.io().newOutputFile(newTableMetadataFilePath);
        TableMetadataParser.overwrite(metadata, newMetadataLocation);
        return newMetadataLocation.location();
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        this.refreshFromMetadataLocation(newLocation, null, 20);
    }

    protected void refreshFromMetadataLocation(String newLocation, int numRetries) {
        this.refreshFromMetadataLocation(newLocation, null, numRetries);
    }

    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        if (!Objects.equal(this.currentMetadataLocation, newLocation)) {
            LOG.info("Refreshing table metadata from new version: {}", (Object)newLocation);
            AtomicReference newMetadata = new AtomicReference();
            Tasks.foreach(newLocation).retry(numRetries).exponentialBackoff(100L, 5000L, 600000L, 4.0).throwFailureWhenFinished().shouldRetryTest(shouldRetry).run(metadataLocation -> newMetadata.set(TableMetadataParser.read(this.io(), metadataLocation)));
            String newUUID = ((TableMetadata)newMetadata.get()).uuid();
            if (this.currentMetadata != null && this.currentMetadata.uuid() != null && newUUID != null) {
                Preconditions.checkState(newUUID.equals(this.currentMetadata.uuid()), "Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
            }
            this.currentMetadata = (TableMetadata)newMetadata.get();
            this.currentMetadataLocation = newLocation;
            this.version = BaseMetastoreTableOperations.parseVersion(newLocation);
        }
        this.shouldRefresh = false;
    }

    private String metadataFileLocation(TableMetadata metadata, String filename) {
        String metadataLocation = metadata.properties().get("write.metadata.path");
        if (metadataLocation != null) {
            return String.format("%s/%s", metadataLocation, filename);
        }
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    @Override
    public String metadataFileLocation(String filename) {
        return this.metadataFileLocation(this.current(), filename);
    }

    @Override
    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor(this.current().location(), this.current().properties());
    }

    @Override
    public TableOperations temp(final TableMetadata uncommittedMetadata) {
        return new TableOperations(){

            @Override
            public TableMetadata current() {
                return uncommittedMetadata;
            }

            @Override
            public TableMetadata refresh() {
                throw new UnsupportedOperationException("Cannot call refresh on temporary table operations");
            }

            @Override
            public void commit(TableMetadata base, TableMetadata metadata) {
                throw new UnsupportedOperationException("Cannot call commit on temporary table operations");
            }

            @Override
            public String metadataFileLocation(String fileName) {
                return BaseMetastoreTableOperations.this.metadataFileLocation(uncommittedMetadata, fileName);
            }

            @Override
            public LocationProvider locationProvider() {
                return LocationProviders.locationsFor(uncommittedMetadata.location(), uncommittedMetadata.properties());
            }

            @Override
            public FileIO io() {
                return BaseMetastoreTableOperations.this.io();
            }

            @Override
            public EncryptionManager encryption() {
                return BaseMetastoreTableOperations.this.encryption();
            }

            @Override
            public long newSnapshotId() {
                return BaseMetastoreTableOperations.this.newSnapshotId();
            }
        };
    }

    private String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
        String codecName = meta.property("write.metadata.compression-codec", "none");
        String fileExtension = TableMetadataParser.getFileExtension(codecName);
        return this.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), fileExtension));
    }

    private static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        try {
            return Integer.valueOf(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse version from metadata location: {}", (Object)metadataLocation, (Object)e);
            return -1;
        }
    }

    private void deleteRemovedMetadataFiles(TableMetadata base, TableMetadata metadata) {
        if (base == null) {
            return;
        }
        boolean deleteAfterCommit = metadata.propertyAsBoolean("write.metadata.delete-after-commit.enabled", false);
        HashSet<TableMetadata.MetadataLogEntry> removedPreviousMetadataFiles = Sets.newHashSet(base.previousFiles());
        removedPreviousMetadataFiles.removeAll(metadata.previousFiles());
        if (deleteAfterCommit) {
            Tasks.foreach(removedPreviousMetadataFiles).noRetry().suppressFailureWhenFinished().onFailure((previousMetadataFile, exc) -> LOG.warn("Delete failed for previous metadata file: {}", previousMetadataFile, (Object)exc)).run(previousMetadataFile -> this.io().deleteFile(previousMetadataFile.file()));
        }
    }
}

