/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.ThreadPools;

public class AllEntriesTable
extends BaseMetadataTable {
    private final TableOperations ops;
    private final Table table;
    private final String name;

    AllEntriesTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".all_entries");
    }

    AllEntriesTable(TableOperations ops, Table table, String name) {
        this.ops = ops;
        this.table = table;
        this.name = name;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TableScan newScan() {
        return new Scan(this.ops, this.table, this.schema());
    }

    @Override
    public Schema schema() {
        Schema schema = ManifestEntry.getSchema(this.table.spec().partitionType());
        if (this.table.spec().fields().size() < 1) {
            return TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return schema;
    }

    @Override
    String metadataLocation() {
        return this.ops.current().metadataFileLocation();
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_ENTRIES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CloseableIterable<ManifestFile> allManifestFiles(List<Snapshot> snapshots) {
        try (ParallelIterable iterable = new ParallelIterable(Iterables.transform(snapshots, snapshot -> () -> snapshot.allManifests().iterator()), ThreadPools.getWorkerPool());){
            CloseableIterable<ManifestFile> closeableIterable = CloseableIterable.withNoopClose(Sets.newHashSet(iterable));
            return closeableIterable;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close parallel iterable", new Object[0]);
        }
    }

    private static class Scan
    extends BaseAllMetadataTableScan {
        Scan(TableOperations ops, Table table, Schema schema) {
            super(ops, table, schema);
        }

        private Scan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new Scan(ops, table, schema, context);
        }

        @Override
        protected long targetSplitSize(TableOperations ops) {
            return ops.current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            CloseableIterable manifests = AllEntriesTable.allManifestFiles(ops.current().snapshots());
            Type fileProjection = this.schema().findType("data_file");
            Schema fileSchema = fileProjection != null ? new Schema(fileProjection.asStructType().fields()) : new Schema(new Types.NestedField[0]);
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
            return CloseableIterable.transform(manifests, manifest -> new ManifestEntriesTable.ManifestReadTask(ops.io(), (ManifestFile)manifest, fileSchema, schemaString, specString, residuals, ops.current().specsById()));
        }
    }
}

