/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Validation {
    public static final String HASH_REGEX = "^[0-9a-fA-F]{16,64}$";
    public static final String REF_NAME_REGEX = "^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$";
    public static final String REF_NAME_OR_HASH_REGEX = "^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$";
    public static final Pattern HASH_PATTERN = Pattern.compile("^[0-9a-fA-F]{16,64}$");
    public static final Pattern REF_NAME_PATTERN = Pattern.compile("^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$");
    public static final Pattern REF_NAME_OR_HASH_PATTERN = Pattern.compile("^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$");
    private static final String HASH_RULE = "consist of the hex representation of 8-32 bytes";
    private static final String REF_RULE = "start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..";
    public static final String HASH_MESSAGE = "Hash must consist of the hex representation of 8-32 bytes";
    public static final String REF_NAME_MESSAGE = "Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..";
    public static final String REF_NAME_OR_HASH_MESSAGE = "Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes";

    private Validation() {
    }

    public static boolean isValidReferenceName(String referenceName) {
        Objects.requireNonNull(referenceName, "referenceName must not be null");
        Matcher matcher = REF_NAME_PATTERN.matcher(referenceName);
        return matcher.matches();
    }

    public static boolean isValidHash(String hash) {
        Objects.requireNonNull(hash, "hash must not be null");
        Matcher matcher = HASH_PATTERN.matcher(hash);
        return matcher.matches();
    }

    public static boolean isValidReferenceNameOrHash(String ref) {
        Objects.requireNonNull(ref, "reference (name or hash) must not be null");
        Matcher matcher = REF_NAME_OR_HASH_PATTERN.matcher(ref);
        return matcher.matches();
    }

    public static String validateReferenceName(String referenceName) {
        if (Validation.isValidReferenceName(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + referenceName);
    }

    public static String validateHash(String referenceName) {
        if (Validation.isValidHash(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Hash must consist of the hex representation of 8-32 bytes - but was: " + referenceName);
    }

    public static String validateReferenceNameOrHash(String ref) {
        if (Validation.isValidReferenceNameOrHash(ref)) {
            return ref;
        }
        throw new IllegalArgumentException("Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes - but was: " + ref);
    }
}

