/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.http;

import com.dremio.nessie.client.http.HttpClient;
import com.dremio.nessie.client.http.HttpClientException;
import com.dremio.nessie.client.http.HttpResponse;
import com.dremio.nessie.client.http.RequestContext;
import com.dremio.nessie.client.http.RequestFilter;
import com.dremio.nessie.client.http.ResponseContextImpl;
import com.dremio.nessie.client.http.ResponseFilter;
import com.dremio.nessie.client.http.UriBuilder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class HttpRequest {
    private final UriBuilder uriBuilder;
    private final ObjectMapper mapper;
    private final Map<String, Set<String>> headers = new HashMap<String, Set<String>>();
    private final List<RequestFilter> requestFilters;
    private final List<ResponseFilter> responseFilters;
    private SSLContext sslContext;

    HttpRequest(String baseUri, String accept, ObjectMapper mapper, List<RequestFilter> requestFilters, List<ResponseFilter> responseFilters, SSLContext context) {
        this.uriBuilder = new UriBuilder(baseUri);
        this.mapper = mapper;
        HttpRequest.putHeader("Accept", accept, this.headers);
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
        this.sslContext = context;
    }

    static void putHeader(String key, String value, Map<String, Set<String>> headers) {
        if (!headers.containsKey(key)) {
            headers.put(key, new HashSet());
        }
        headers.get(key).add(value);
    }

    public HttpRequest path(String path) {
        this.uriBuilder.path(path);
        return this;
    }

    public HttpRequest queryParam(String name, String value) {
        this.uriBuilder.queryParam(name, value);
        return this;
    }

    public HttpRequest header(String name, String value) {
        HttpRequest.putHeader(name, value, this.headers);
        return this;
    }

    private HttpResponse executeRequest(HttpClient.Method method, Object body) throws HttpClientException {
        try {
            String uri = this.uriBuilder.build();
            URL url = new URL(uri);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            if (con instanceof HttpsURLConnection) {
                ((HttpsURLConnection)con).setSSLSocketFactory(this.sslContext.getSocketFactory());
            }
            RequestContext context = new RequestContext(this.headers, uri, method, body);
            this.requestFilters.forEach(a -> a.filter(context));
            this.headers.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream().map(x -> new AbstractMap.SimpleImmutableEntry<String, String>((String)e.getKey(), (String)x))).forEach(x -> con.setRequestProperty((String)x.getKey(), (String)x.getValue()));
            con.setRequestMethod(method.name());
            if (method.equals((Object)HttpClient.Method.PUT) || method.equals((Object)HttpClient.Method.POST)) {
                con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                if (body != null) {
                    con.setDoOutput(true);
                    Class<?> bodyType = body.getClass();
                    if (bodyType != String.class) {
                        this.mapper.writerFor(bodyType).writeValue(con.getOutputStream(), body);
                    } else {
                        con.getOutputStream().write(((String)body).getBytes(StandardCharsets.UTF_8));
                    }
                }
            }
            con.connect();
            con.getResponseCode();
            ResponseContextImpl responseContext = new ResponseContextImpl(con);
            this.responseFilters.forEach(a -> a.filter(responseContext));
            return new HttpResponse(responseContext, this.mapper);
        }
        catch (ProtocolException e2) {
            throw new HttpClientException(String.format("Cannot perform request. Invalid protocol %s", new Object[]{method}), e2);
        }
        catch (JsonGenerationException | JsonMappingException e3) {
            throw new HttpClientException(String.format("Cannot serialize body of request. Unable to serialize %s", body.getClass()), e3);
        }
        catch (MalformedURLException e4) {
            throw new HttpClientException(String.format("Cannot perform request. Malformed Url for %s", this.uriBuilder.build()), e4);
        }
        catch (IOException e5) {
            throw new HttpClientException(e5);
        }
    }

    public HttpRequest setSslContext(SSLContext context) {
        this.sslContext = context;
        return this;
    }

    public HttpResponse get() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.GET, null);
    }

    public HttpResponse delete() throws HttpClientException {
        return this.executeRequest(HttpClient.Method.DELETE, null);
    }

    public HttpResponse post(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.POST, obj);
    }

    public HttpResponse put(Object obj) throws HttpClientException {
        return this.executeRequest(HttpClient.Method.PUT, obj);
    }

    public HttpRequest resolveTemplate(String name, String value) {
        this.uriBuilder.resolveTemplate(name, value);
        return this;
    }
}

