/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.http;

import com.dremio.nessie.client.http.HttpClientException;
import com.dremio.nessie.client.http.HttpRequest;
import com.dremio.nessie.client.http.HttpUtils;
import com.dremio.nessie.client.http.RequestFilter;
import com.dremio.nessie.client.http.ResponseFilter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class HttpClient {
    private final String baseUri;
    private final String accept;
    private final ObjectMapper mapper;
    private final SSLContext sslContext;
    private final List<RequestFilter> requestFilters = new ArrayList<RequestFilter>();
    private final List<ResponseFilter> responseFilters = new ArrayList<ResponseFilter>();

    private HttpClient(String baseUri, String accept, ObjectMapper mapper, SSLContext sslContext) {
        this.baseUri = HttpUtils.checkNonNullTrim(baseUri);
        this.accept = HttpUtils.checkNonNullTrim(accept);
        this.mapper = mapper;
        this.sslContext = sslContext;
        HttpUtils.checkArgument(baseUri.startsWith("http://") || baseUri.startsWith("https://"), "Cannot start http client. %s must be a valid http or https address", baseUri);
    }

    public void register(RequestFilter filter) {
        this.requestFilters.add(filter);
    }

    public void register(ResponseFilter filter) {
        this.responseFilters.add(filter);
    }

    public HttpRequest newRequest() {
        return new HttpRequest(this.baseUri, this.accept, this.mapper, this.requestFilters, this.responseFilters, this.sslContext);
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    public static class HttpClientBuilder {
        private String baseUri;
        private String accept = "application/json";
        private ObjectMapper mapper;
        private SSLContext sslContext;

        public String getBaseUri() {
            return this.baseUri;
        }

        public HttpClientBuilder setBaseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public String getAccept() {
            return this.accept;
        }

        public HttpClientBuilder setAccept(String accept) {
            this.accept = accept;
            return this;
        }

        public ObjectMapper getMapper() {
            return this.mapper;
        }

        public HttpClientBuilder setObjectMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public HttpClientBuilder setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public HttpClient build() {
            HttpUtils.checkArgument(this.baseUri != null, "Cannot construct Http client. Must have a non-null uri", new Object[0]);
            HttpUtils.checkArgument(this.accept != null, "Cannot construct Http client. Must have a non-null accept string", new Object[0]);
            HttpUtils.checkArgument(this.mapper != null, "Cannot construct Http client. Must have a non-null object mapper", new Object[0]);
            if (this.sslContext == null) {
                try {
                    this.sslContext = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new HttpClientException("Cannot construct Http Client. Default SSL config is invalid.", e);
                }
            }
            return new HttpClient(this.baseUri, this.accept, this.mapper, this.sslContext);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

