/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column.values.rle;

import java.io.IOException;
import java.util.Objects;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.BytesInput;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.ValuesWriter;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.iceberg.shaded.org.apache.parquet.io.ParquetEncodingException;

public class RunLengthBitPackingHybridValuesWriter
extends ValuesWriter {
    protected final RunLengthBitPackingHybridEncoder encoder;

    public RunLengthBitPackingHybridValuesWriter(int bitWidth, int initialCapacity, int pageSize, ByteBufferAllocator allocator) {
        this(new RunLengthBitPackingHybridEncoder(bitWidth, initialCapacity, pageSize, allocator));
    }

    protected RunLengthBitPackingHybridValuesWriter(RunLengthBitPackingHybridEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.encoder.writeInt(v);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.writeInteger(v ? 1 : 0);
    }

    @Override
    public long getBufferedSize() {
        return this.encoder.getBufferedSize();
    }

    @Override
    public long getAllocatedSize() {
        return this.encoder.getAllocatedSize();
    }

    @Override
    public BytesInput getBytes() {
        try {
            BytesInput rle = this.encoder.toBytes();
            return BytesInput.concat(BytesInput.fromInt(Math.toIntExact(rle.size())), rle);
        }
        catch (IOException e) {
            throw new ParquetEncodingException(e);
        }
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.RLE;
    }

    @Override
    public void reset() {
        this.encoder.reset();
    }

    @Override
    public void close() {
        this.encoder.close();
    }

    @Override
    public String memUsageString(String prefix) {
        return String.format("%s RunLengthBitPackingHybrid %d bytes", prefix, this.getAllocatedSize());
    }
}

