/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.avro;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.shaded.org.apache.avro.Conversion;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericArray;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericData;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroConverters;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroRecordConverter;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.iceberg.shaded.org.apache.parquet.avro.ParentValueContainer;
import org.apache.iceberg.shaded.org.apache.parquet.io.InvalidRecordException;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Converter;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.GroupConverter;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;

class AvroIndexedRecordConverter<T extends IndexedRecord>
extends GroupConverter {
    private final ParentValueContainer parent;
    protected T currentRecord;
    private final Converter[] converters;
    private final Schema avroSchema;
    private final Class<? extends IndexedRecord> specificClass;
    private final GenericData model;
    private final Map<Schema.Field, Object> recordDefaults = new HashMap<Schema.Field, Object>();

    public AvroIndexedRecordConverter(MessageType parquetSchema, Schema avroSchema) {
        this(parquetSchema, avroSchema, SpecificData.get());
    }

    public AvroIndexedRecordConverter(MessageType parquetSchema, Schema avroSchema, GenericData baseModel) {
        this(null, parquetSchema, avroSchema, baseModel);
    }

    public AvroIndexedRecordConverter(ParentValueContainer parent, GroupType parquetSchema, Schema avroSchema) {
        this(parent, parquetSchema, avroSchema, SpecificData.get());
    }

    public AvroIndexedRecordConverter(ParentValueContainer parent, GroupType parquetSchema, Schema avroSchema, GenericData baseModel) {
        this.parent = parent;
        this.avroSchema = avroSchema;
        int schemaSize = parquetSchema.getFieldCount();
        this.converters = new Converter[schemaSize];
        this.specificClass = AvroIndexedRecordConverter.getDatumClass(baseModel, avroSchema);
        this.model = this.specificClass == null ? GenericData.get() : baseModel;
        HashMap<String, Integer> avroFieldIndexes = new HashMap<String, Integer>();
        int avroFieldIndex = 0;
        for (Schema.Field field : avroSchema.getFields()) {
            avroFieldIndexes.put(field.name(), avroFieldIndex++);
        }
        int parquetFieldIndex = 0;
        for (Type parquetField : parquetSchema.getFields()) {
            Schema.Field avroField = this.getAvroField(parquetField.getName());
            Schema nonNullSchema = AvroSchemaConverter.getNonNull(avroField.schema());
            final int finalAvroIndex = (Integer)avroFieldIndexes.remove(avroField.name());
            this.converters[parquetFieldIndex++] = AvroIndexedRecordConverter.newConverter(nonNullSchema, parquetField, this.model, new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    AvroIndexedRecordConverter.this.set(finalAvroIndex, value);
                }
            });
        }
        for (String fieldName : avroFieldIndexes.keySet()) {
            Schema.Field field = avroSchema.getField(fieldName);
            if (field.schema().getType() == Schema.Type.NULL || field.defaultVal() == null || this.model.getDefaultValue(field) == null) continue;
            this.recordDefaults.put(field, this.model.getDefaultValue(field));
        }
    }

    private static <T> Class<T> getDatumClass(GenericData model, Schema schema) {
        if (model.getConversionFor(schema.getLogicalType()) != null) {
            return null;
        }
        if (model instanceof SpecificData) {
            return ((SpecificData)model).getClass(schema);
        }
        return null;
    }

    private Schema.Field getAvroField(String parquetFieldName) {
        Schema.Field avroField = this.avroSchema.getField(parquetFieldName);
        for (Schema.Field f : this.avroSchema.getFields()) {
            if (!f.aliases().contains(parquetFieldName)) continue;
            return f;
        }
        if (avroField == null) {
            throw new InvalidRecordException(String.format("Parquet/Avro schema mismatch. Avro field '%s' not found.", parquetFieldName));
        }
        return avroField;
    }

    private static Converter newConverter(Schema schema, Type type, GenericData model, ParentValueContainer setter) {
        LogicalType logicalType = schema.getLogicalType();
        Conversion<Object> conversion = model.getConversionFor(logicalType);
        ParentValueContainer parent = ParentValueContainer.getConversionContainer(setter, conversion, schema);
        if (schema.getType().equals((Object)Schema.Type.BOOLEAN)) {
            return new AvroConverters.FieldBooleanConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.INT)) {
            return new AvroConverters.FieldIntegerConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.LONG)) {
            return new AvroConverters.FieldLongConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.FLOAT)) {
            return new AvroConverters.FieldFloatConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.DOUBLE)) {
            return new AvroConverters.FieldDoubleConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.BYTES)) {
            return new AvroConverters.FieldByteBufferConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.STRING)) {
            return new AvroConverters.FieldStringConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.RECORD)) {
            return new AvroIndexedRecordConverter(parent, type.asGroupType(), schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.ENUM)) {
            return new FieldEnumConverter(parent, schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.ARRAY)) {
            return new AvroArrayConverter(parent, type.asGroupType(), schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.MAP)) {
            return new MapConverter(parent, type.asGroupType(), schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            return new AvroUnionConverter(parent, type, schema, model);
        }
        if (schema.getType().equals((Object)Schema.Type.FIXED)) {
            return new FieldFixedConverter(parent, schema, model);
        }
        throw new UnsupportedOperationException(String.format("Cannot convert Avro type: %s (Parquet type: %s) ", schema, type));
    }

    private void set(int index, Object value) {
        this.currentRecord.put(index, value);
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    @Override
    public void start() {
        this.currentRecord = (IndexedRecord)(this.specificClass == null ? new GenericData.Record(this.avroSchema) : SpecificData.newInstance(this.specificClass, this.avroSchema));
    }

    @Override
    public void end() {
        this.fillInDefaults();
        if (this.parent != null) {
            this.parent.add(this.currentRecord);
        }
    }

    private void fillInDefaults() {
        for (Map.Entry<Schema.Field, Object> entry : this.recordDefaults.entrySet()) {
            Schema.Field f = entry.getKey();
            Object defaultValue = this.deepCopy(f.schema(), entry.getValue());
            this.currentRecord.put(f.pos(), defaultValue);
        }
    }

    private Object deepCopy(Schema schema, Object value) {
        switch (schema.getType()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return value;
            }
        }
        return this.model.deepCopy(schema, value);
    }

    T getCurrentRecord() {
        return this.currentRecord;
    }

    static final class MapConverter<V>
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Converter keyValueConverter;
        private Map<String, V> map;

        public MapConverter(ParentValueContainer parent, GroupType mapType, Schema mapSchema, GenericData model) {
            this.parent = parent;
            GroupType repeatedKeyValueType = mapType.getType(0).asGroupType();
            this.keyValueConverter = new MapKeyValueConverter(repeatedKeyValueType, mapSchema, model);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.keyValueConverter;
        }

        @Override
        public void start() {
            this.map = new HashMap<String, V>();
        }

        @Override
        public void end() {
            this.parent.add(this.map);
        }

        final class MapKeyValueConverter
        extends GroupConverter {
            private String key;
            private V value;
            private final Converter keyConverter;
            private final Converter valueConverter;

            public MapKeyValueConverter(GroupType keyValueType, Schema mapSchema, GenericData model) {
                this.keyConverter = new PrimitiveConverter(){

                    @Override
                    public final void addBinary(Binary value) {
                        MapKeyValueConverter.this.key = value.toStringUsingUTF8();
                    }
                };
                Type valueType = keyValueType.getType(1);
                Schema nonNullValueSchema = AvroSchemaConverter.getNonNull(mapSchema.getValueType());
                this.valueConverter = AvroIndexedRecordConverter.newConverter(nonNullValueSchema, valueType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        MapKeyValueConverter.this.value = value;
                    }
                });
            }

            @Override
            public Converter getConverter(int fieldIndex) {
                if (fieldIndex == 0) {
                    return this.keyConverter;
                }
                if (fieldIndex == 1) {
                    return this.valueConverter;
                }
                throw new IllegalArgumentException("only the key (0) and value (1) fields expected: " + fieldIndex);
            }

            @Override
            public void start() {
                this.key = null;
                this.value = null;
            }

            @Override
            public void end() {
                MapConverter.this.map.put(this.key, this.value);
            }
        }
    }

    static final class AvroUnionConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Converter[] memberConverters;
        private Object memberValue = null;

        public AvroUnionConverter(ParentValueContainer parent, Type parquetSchema, Schema avroSchema, GenericData model) {
            this.parent = parent;
            GroupType parquetGroup = parquetSchema.asGroupType();
            this.memberConverters = new Converter[parquetGroup.getFieldCount()];
            int parquetIndex = 0;
            for (int index = 0; index < avroSchema.getTypes().size(); ++index) {
                Schema memberSchema = avroSchema.getTypes().get(index);
                if (memberSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                Type memberType = parquetGroup.getType(parquetIndex);
                this.memberConverters[parquetIndex] = AvroIndexedRecordConverter.newConverter(memberSchema, memberType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        Preconditions.checkArgument(memberValue == null, "Union is resolving to more than one type");
                        memberValue = value;
                    }
                });
                ++parquetIndex;
            }
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.memberConverters[fieldIndex];
        }

        @Override
        public void start() {
            this.memberValue = null;
        }

        @Override
        public void end() {
            this.parent.add(this.memberValue);
        }
    }

    static final class AvroArrayConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Converter converter;
        private GenericArray<Object> array;

        public AvroArrayConverter(ParentValueContainer parent, GroupType type, Schema avroSchema, GenericData model) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            Schema elementSchema = AvroSchemaConverter.getNonNull(avroSchema.getElementType());
            Type repeatedType = type.getType(0);
            this.converter = AvroRecordConverter.isElementType(repeatedType, elementSchema) ? AvroIndexedRecordConverter.newConverter(elementSchema, repeatedType, model, new ParentValueContainer(){

                @Override
                public void add(Object value) {
                    array.add(value);
                }
            }) : new ElementConverter(repeatedType.asGroupType(), elementSchema, model);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        @Override
        public void start() {
            this.array = new GenericData.Array<Object>(0, this.avroSchema);
        }

        @Override
        public void end() {
            this.parent.add(this.array);
        }

        final class ElementConverter
        extends GroupConverter {
            private Object element;
            private final Converter elementConverter;

            public ElementConverter(GroupType repeatedType, Schema elementSchema, GenericData model) {
                Type elementType = repeatedType.getType(0);
                Schema nonNullElementSchema = AvroSchemaConverter.getNonNull(elementSchema);
                this.elementConverter = AvroIndexedRecordConverter.newConverter(nonNullElementSchema, elementType, model, new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        ElementConverter.this.element = value;
                    }
                });
            }

            @Override
            public Converter getConverter(int fieldIndex) {
                Preconditions.checkArgument(fieldIndex == 0, "Illegal field index: " + fieldIndex);
                return this.elementConverter;
            }

            @Override
            public void start() {
                this.element = null;
            }

            @Override
            public void end() {
                AvroArrayConverter.this.array.add(this.element);
            }
        }
    }

    static final class FieldFixedConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Class<? extends GenericData.Fixed> fixedClass;
        private final Constructor fixedClassCtor;

        public FieldFixedConverter(ParentValueContainer parent, Schema avroSchema, GenericData model) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            Class clazz = this.fixedClass = model instanceof SpecificData ? ((SpecificData)model).getClass(avroSchema) : SpecificData.get().getClass(avroSchema);
            if (this.fixedClass != null) {
                try {
                    this.fixedClassCtor = this.fixedClass.getConstructor(byte[].class);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.fixedClassCtor = null;
            }
        }

        @Override
        public final void addBinary(Binary value) {
            if (this.fixedClass == null) {
                this.parent.add(new GenericData.Fixed(this.avroSchema, value.getBytes()));
            } else {
                if (this.fixedClassCtor == null) {
                    throw new IllegalArgumentException("fixedClass specified but fixedClassCtor is null.");
                }
                try {
                    Object fixed = this.fixedClassCtor.newInstance(new Object[]{value.getBytes()});
                    this.parent.add(fixed);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static final class FieldEnumConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final Class<? extends Enum> enumClass;

        public FieldEnumConverter(ParentValueContainer parent, Schema enumSchema, GenericData model) {
            this.parent = parent;
            this.enumClass = model instanceof SpecificData ? ((SpecificData)model).getClass(enumSchema) : SpecificData.get().getClass(enumSchema);
        }

        @Override
        public final void addBinary(Binary value) {
            Object enumValue = value.toStringUsingUTF8();
            if (this.enumClass != null) {
                enumValue = Enum.valueOf(this.enumClass, (String)enumValue);
            }
            this.parent.add(enumValue);
        }
    }
}

