/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LocalCache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.stats.CacheStats;
import org.apache.iceberg.shaded.org.checkerframework.checker.nullness.qual.Nullable;

interface LocalManualCache<K, V>
extends Cache<K, V> {
    public LocalCache<K, V> cache();

    @Override
    default public long estimatedSize() {
        return this.cache().estimatedSize();
    }

    @Override
    default public void cleanUp() {
        this.cache().cleanUp();
    }

    @Override
    default public @Nullable V getIfPresent(Object key) {
        return this.cache().getIfPresent(key, true);
    }

    @Override
    default public @Nullable V get(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache().computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    default public Map<K, V> getAllPresent(Iterable<?> keys) {
        return this.cache().getAllPresent(keys);
    }

    @Override
    default public void put(K key, V value) {
        this.cache().put(key, value);
    }

    @Override
    default public void putAll(Map<? extends K, ? extends V> map) {
        this.cache().putAll(map);
    }

    @Override
    default public void invalidate(Object key) {
        this.cache().remove(key);
    }

    @Override
    default public void invalidateAll(Iterable<?> keys) {
        this.cache().invalidateAll(keys);
    }

    @Override
    default public void invalidateAll() {
        this.cache().clear();
    }

    @Override
    default public CacheStats stats() {
        return this.cache().statsCounter().snapshot();
    }

    @Override
    default public ConcurrentMap<K, V> asMap() {
        return this.cache();
    }
}

