/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Hash;
import com.dremio.nessie.model.Reference;

class UpdateableReference {
    private Reference reference;
    private final TreeApi client;

    UpdateableReference(Reference reference, TreeApi client) {
        this.reference = reference;
        this.client = client;
    }

    public boolean refresh() throws NessieNotFoundException {
        if (this.reference instanceof Hash) {
            return false;
        }
        Reference oldReference = this.reference;
        this.reference = this.client.getReferenceByName(this.reference.getName());
        return !oldReference.equals(this.reference);
    }

    public boolean isBranch() {
        return this.reference instanceof Branch;
    }

    public UpdateableReference copy() {
        return new UpdateableReference(this.reference, this.client);
    }

    public String getHash() {
        return this.reference.getHash();
    }

    public Branch getAsBranch() {
        if (!this.isBranch()) {
            throw new IllegalArgumentException("Reference is not a branch");
        }
        return (Branch)this.reference;
    }

    public void checkMutable() {
        if (!this.isBranch()) {
            throw new IllegalArgumentException("You can only mutate tables when using a branch.");
        }
    }

    public String getName() {
        return this.reference.getName();
    }
}

