/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.EntriesResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;

public final class NessieUtil {
    private NessieUtil() {
    }

    static Predicate<EntriesResponse.Entry> namespacePredicate(Namespace ns) {
        if (ns == null) {
            return e -> true;
        }
        List<String> namespace = Arrays.asList(ns.levels());
        Predicate<EntriesResponse.Entry> predicate = e -> {
            List<String> names = e.getName().getElements();
            if (names.size() <= namespace.size()) {
                return false;
            }
            return namespace.equals(names.subList(0, namespace.size()));
        };
        return predicate;
    }

    static TableIdentifier toIdentifier(EntriesResponse.Entry entry) {
        List<String> elements = entry.getName().getElements();
        return TableIdentifier.of(elements.toArray(new String[elements.size()]));
    }

    static TableIdentifier removeCatalogName(TableIdentifier to, String name) {
        String[] levels = to.namespace().levels();
        if (levels.length >= 2 && name.equalsIgnoreCase(to.namespace().level(0))) {
            Namespace trimmedNamespace = Namespace.of(Arrays.copyOfRange(levels, 1, levels.length));
            return TableIdentifier.of(trimmedNamespace, to.name());
        }
        return to;
    }

    static ContentsKey toKey(TableIdentifier tableIdentifier) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (tableIdentifier.hasNamespace()) {
            identifiers.addAll(Arrays.asList(tableIdentifier.namespace().levels()));
        }
        identifiers.add(tableIdentifier.name());
        ContentsKey key = new ContentsKey(identifiers);
        return key;
    }
}

