/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.BaseNessieClientServerException;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.IcebergTable;
import com.dremio.nessie.model.ImmutableDelete;
import com.dremio.nessie.model.ImmutableOperations;
import com.dremio.nessie.model.ImmutablePut;
import com.dremio.nessie.model.Operations;
import com.dremio.nessie.model.Reference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieTableOperations;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.TableReference;
import org.apache.iceberg.nessie.UpdateableReference;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieCatalog
extends BaseMetastoreCatalog
implements AutoCloseable,
SupportsNamespaces,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(NessieCatalog.class);
    private static final Joiner SLASH = Joiner.on("/");
    private NessieClient client;
    private String warehouseLocation;
    private Configuration config;
    private UpdateableReference reference;
    private String name;
    private FileIO fileIO;

    @Override
    public void initialize(String inputName, Map<String, String> options) {
        String fileIOImpl = options.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.config) : CatalogUtil.loadFileIO(fileIOImpl, options, this.config);
        this.name = inputName == null ? "nessie" : inputName;
        Function<String, String> removePrefix = x -> x.replace("nessie.", "");
        this.client = NessieClient.withConfig(x -> (String)options.get(removePrefix.apply((String)x)));
        this.warehouseLocation = options.get("warehouse");
        if (this.warehouseLocation == null) {
            throw new IllegalStateException("Parameter warehouse not set, nessie can't store data.");
        }
        String requestedRef = options.get(removePrefix.apply("nessie.ref"));
        this.reference = this.loadReference(requestedRef);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        TableReference pti = TableReference.parse(tableIdentifier);
        UpdateableReference newReference = this.reference;
        if (pti.reference() != null) {
            newReference = this.loadReference(pti.reference());
        }
        return new NessieTableOperations(NessieUtil.toKey(pti.tableIdentifier()), newReference, this.client, this.fileIO);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier table) {
        if (table.hasNamespace()) {
            return SLASH.join(this.warehouseLocation, table.namespace().toString(), table.name());
        }
        return SLASH.join(this.warehouseLocation, table.name(), new Object[0]);
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.tableStream(namespace).collect(Collectors.toList());
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        this.reference.checkMutable();
        IcebergTable existingTable = this.table(identifier);
        if (existingTable == null) {
            return false;
        }
        boolean threw = true;
        try {
            Tasks.foreach(identifier).retry(5).stopRetryOn(NessieNotFoundException.class).throwFailureWhenFinished().run(this::dropTableInner, BaseNessieClientServerException.class);
            threw = false;
        }
        catch (NessieConflictException e) {
            logger.error("Cannot drop table: failed after retry (update ref and retry)", (Throwable)e);
        }
        catch (NessieNotFoundException e) {
            logger.error("Cannot drop table: ref is no longer valid.", (Throwable)e);
        }
        catch (BaseNessieClientServerException e) {
            logger.error("Cannot drop table: unknown error", (Throwable)e);
        }
        return !threw;
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier toOriginal) {
        this.reference.checkMutable();
        TableIdentifier to = NessieUtil.removeCatalogName(toOriginal, this.name());
        IcebergTable existingFromTable = this.table(from);
        if (existingFromTable == null) {
            throw new NoSuchTableException("table %s doesn't exists", from.name());
        }
        IcebergTable existingToTable = this.table(to);
        if (existingToTable != null) {
            throw new AlreadyExistsException("table %s already exists", to.name());
        }
        ImmutableOperations contents = ImmutableOperations.builder().addOperations(ImmutablePut.builder().key(NessieUtil.toKey(to)).contents(existingFromTable).build(), ImmutableDelete.builder().key(NessieUtil.toKey(from)).build()).build();
        try {
            Tasks.foreach(contents).retry(5).stopRetryOn(NessieNotFoundException.class).throwFailureWhenFinished().run(c -> {
                this.client.getTreeApi().commitMultipleOperations(this.reference.getAsBranch().getName(), this.reference.getHash(), "iceberg rename table", (Operations)c);
                this.refresh();
            }, BaseNessieClientServerException.class);
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException("Failed to drop table as ref is no longer valid.", e);
        }
        catch (BaseNessieClientServerException e) {
            throw new CommitFailedException(e, "Failed to rename table: the current reference is not up to date.", new Object[0]);
        }
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        return this.tableStream(namespace).map(TableIdentifier::namespace).filter(n -> !n.isEmpty()).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        return ImmutableMap.of();
    }

    @Override
    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        return false;
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        throw new UnsupportedOperationException("Cannot set namespace properties " + namespace + " : setProperties is not supported");
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        throw new UnsupportedOperationException("Cannot remove properties " + namespace + " : removeProperties is not supported");
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }

    TreeApi getTreeApi() {
        return this.client.getTreeApi();
    }

    public void refresh() throws NessieNotFoundException {
        this.reference.refresh();
    }

    public String currentHash() {
        return this.reference.getHash();
    }

    String currentRefName() {
        return this.reference.getName();
    }

    private IcebergTable table(TableIdentifier tableIdentifier) {
        try {
            Contents table = this.client.getContentsApi().getContents(NessieUtil.toKey(tableIdentifier), this.reference.getHash());
            return table.unwrap(IcebergTable.class).orElse(null);
        }
        catch (NessieNotFoundException e) {
            return null;
        }
    }

    private UpdateableReference loadReference(String requestedRef) {
        try {
            Reference ref = requestedRef == null ? this.client.getTreeApi().getDefaultBranch() : this.client.getTreeApi().getReferenceByName(requestedRef);
            return new UpdateableReference(ref, this.client.getTreeApi());
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(String.format("Nessie ref '%s' does not exist. This ref must exist before creating a NessieCatalog.", requestedRef), ex);
            }
            throw new IllegalArgumentException(String.format("Nessie does not have an existing default branch.Either configure an alternative ref via %s or create the default branch on the server.", "nessie.ref"), ex);
        }
    }

    public void dropTableInner(TableIdentifier identifier) throws NessieConflictException, NessieNotFoundException {
        try {
            this.client.getContentsApi().deleteContents(NessieUtil.toKey(identifier), this.reference.getAsBranch().getName(), this.reference.getHash(), String.format("delete table %s", identifier));
        }
        finally {
            this.refresh();
        }
    }

    private Stream<TableIdentifier> tableStream(Namespace namespace) {
        try {
            return this.client.getTreeApi().getEntries(this.reference.getHash()).getEntries().stream().filter(NessieUtil.namespacePredicate(namespace)).map(NessieUtil::toIdentifier);
        }
        catch (NessieNotFoundException ex) {
            throw new NoSuchNamespaceException(ex, "Unable to list tables due to missing ref. %s", this.reference.getName());
        }
    }
}

