/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.flink.sink.PartitionedDeltaWriter;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.flink.sink.UnpartitionedDeltaWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedFanoutWriter;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.ArrayUtil;

public class RowDataTaskWriterFactory
implements TaskWriterFactory<RowData> {
    private final Schema schema;
    private final RowType flinkSchema;
    private final PartitionSpec spec;
    private final LocationProvider locations;
    private final FileIO io;
    private final EncryptionManager encryptionManager;
    private final long targetFileSizeBytes;
    private final FileFormat format;
    private final List<Integer> equalityFieldIds;
    private final FileAppenderFactory<RowData> appenderFactory;
    private transient OutputFileFactory outputFileFactory;

    public RowDataTaskWriterFactory(Schema schema, RowType flinkSchema, PartitionSpec spec, LocationProvider locations, FileIO io, EncryptionManager encryptionManager, long targetFileSizeBytes, FileFormat format, Map<String, String> tableProperties, List<Integer> equalityFieldIds) {
        this.schema = schema;
        this.flinkSchema = flinkSchema;
        this.spec = spec;
        this.locations = locations;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.targetFileSizeBytes = targetFileSizeBytes;
        this.format = format;
        this.equalityFieldIds = equalityFieldIds;
        this.appenderFactory = equalityFieldIds == null || equalityFieldIds.isEmpty() ? new FlinkAppenderFactory(schema, flinkSchema, tableProperties, spec) : new FlinkAppenderFactory(schema, flinkSchema, tableProperties, spec, ArrayUtil.toIntArray(equalityFieldIds), schema, null);
    }

    @Override
    public void initialize(int taskId, int attemptId) {
        this.outputFileFactory = new OutputFileFactory(this.spec, this.format, this.locations, this.io, this.encryptionManager, taskId, attemptId);
    }

    @Override
    public TaskWriter<RowData> create() {
        Preconditions.checkNotNull(this.outputFileFactory, "The outputFileFactory shouldn't be null if we have invoked the initialize().");
        if (this.equalityFieldIds == null || this.equalityFieldIds.isEmpty()) {
            if (this.spec.isUnpartitioned()) {
                return new UnpartitionedWriter<RowData>(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes);
            }
            return new RowDataPartitionedFanoutWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema);
        }
        if (this.spec.isUnpartitioned()) {
            return new UnpartitionedDeltaWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema, this.equalityFieldIds);
        }
        return new PartitionedDeltaWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema, this.equalityFieldIds);
    }

    private static class RowDataPartitionedFanoutWriter
    extends PartitionedFanoutWriter<RowData> {
        private final PartitionKey partitionKey;
        private final RowDataWrapper rowDataWrapper;

        RowDataPartitionedFanoutWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<RowData> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, RowType flinkSchema) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
            this.partitionKey = new PartitionKey(spec, schema);
            this.rowDataWrapper = new RowDataWrapper(flinkSchema, schema.asStruct());
        }

        @Override
        protected PartitionKey partition(RowData row) {
            this.partitionKey.partition(this.rowDataWrapper.wrap(row));
            return this.partitionKey;
        }
    }
}

