/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.util.Arrays;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;

public class Namespace {
    private static final Namespace EMPTY_NAMESPACE = new Namespace(new String[0]);
    private static final Joiner DOT = Joiner.on('.');
    private final String[] levels;

    public static Namespace empty() {
        return EMPTY_NAMESPACE;
    }

    public static Namespace of(String ... levels) {
        if (levels.length == 0) {
            return Namespace.empty();
        }
        return new Namespace(levels);
    }

    private Namespace(String[] levels) {
        this.levels = levels;
    }

    public String[] levels() {
        return this.levels;
    }

    public String level(int pos) {
        return this.levels[pos];
    }

    public boolean isEmpty() {
        return this.levels.length == 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)other;
        return Arrays.equals(this.levels, namespace.levels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.levels);
    }

    public String toString() {
        return DOT.join(this.levels);
    }
}

