/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3InputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import software.amazon.awssdk.services.s3.S3Client;

public class S3InputFile
extends BaseS3File
implements InputFile {
    public S3InputFile(S3Client client, S3URI uri) {
        this(client, uri, new AwsProperties());
    }

    public S3InputFile(S3Client client, S3URI uri, AwsProperties awsProperties) {
        super(client, uri, awsProperties);
    }

    @Override
    public long getLength() {
        return this.getObjectMetadata().contentLength();
    }

    @Override
    public SeekableInputStream newStream() {
        return new S3InputStream(this.client(), this.uri(), this.awsProperties());
    }
}

