/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.Schema;

public class RemoveIds
extends AvroSchemaVisitor<org.apache.iceberg.shaded.org.apache.avro.Schema> {
    @Override
    public org.apache.iceberg.shaded.org.apache.avro.Schema record(org.apache.iceberg.shaded.org.apache.avro.Schema record, List<String> names, List<org.apache.iceberg.shaded.org.apache.avro.Schema> types) {
        List<Schema.Field> fields = record.getFields();
        int length = fields.size();
        ArrayList<Schema.Field> newFields = Lists.newArrayListWithExpectedSize(length);
        for (int i = 0; i < length; ++i) {
            newFields.add(RemoveIds.copyField(fields.get(i), types.get(i)));
        }
        return AvroSchemaUtil.copyRecord(record, newFields, null);
    }

    @Override
    public org.apache.iceberg.shaded.org.apache.avro.Schema map(org.apache.iceberg.shaded.org.apache.avro.Schema map, org.apache.iceberg.shaded.org.apache.avro.Schema valueType) {
        org.apache.iceberg.shaded.org.apache.avro.Schema result = org.apache.iceberg.shaded.org.apache.avro.Schema.createMap(valueType);
        for (Map.Entry<String, Object> prop : map.getObjectProps().entrySet()) {
            String key = prop.getKey();
            if (key.equals("key-id") || key.equals("value-id")) continue;
            result.addProp(key, prop.getValue());
        }
        return result;
    }

    @Override
    public org.apache.iceberg.shaded.org.apache.avro.Schema array(org.apache.iceberg.shaded.org.apache.avro.Schema array, org.apache.iceberg.shaded.org.apache.avro.Schema element) {
        org.apache.iceberg.shaded.org.apache.avro.Schema result = org.apache.iceberg.shaded.org.apache.avro.Schema.createArray(element);
        for (Map.Entry<String, Object> prop : array.getObjectProps().entrySet()) {
            String key = prop.getKey();
            if (key.equals("element-id")) continue;
            result.addProp(key, prop.getValue());
        }
        return result;
    }

    @Override
    public org.apache.iceberg.shaded.org.apache.avro.Schema primitive(org.apache.iceberg.shaded.org.apache.avro.Schema primitive) {
        return org.apache.iceberg.shaded.org.apache.avro.Schema.create(primitive.getType());
    }

    @Override
    public org.apache.iceberg.shaded.org.apache.avro.Schema union(org.apache.iceberg.shaded.org.apache.avro.Schema union, List<org.apache.iceberg.shaded.org.apache.avro.Schema> options) {
        return org.apache.iceberg.shaded.org.apache.avro.Schema.createUnion(options);
    }

    private static Schema.Field copyField(Schema.Field field, org.apache.iceberg.shaded.org.apache.avro.Schema newSchema) {
        Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
            String key = prop.getKey();
            if (key == "field-id") continue;
            copy.addProp(key, prop.getValue());
        }
        return copy;
    }

    static org.apache.iceberg.shaded.org.apache.avro.Schema removeIds(Schema schema) {
        return AvroSchemaVisitor.visit(AvroSchemaUtil.convert(schema.asStruct(), "table"), new RemoveIds());
    }

    public static org.apache.iceberg.shaded.org.apache.avro.Schema removeIds(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        return AvroSchemaVisitor.visit(schema, new RemoveIds());
    }
}

