/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

final class TableScanContext {
    private final Long snapshotId;
    private final Expression rowFilter;
    private final boolean ignoreResiduals;
    private final boolean caseSensitive;
    private final boolean colStats;
    private final Schema projectedSchema;
    private final Collection<String> selectedColumns;
    private final ImmutableMap<String, String> options;
    private final Long fromSnapshotId;
    private final Long toSnapshotId;

    TableScanContext() {
        this.snapshotId = null;
        this.rowFilter = Expressions.alwaysTrue();
        this.ignoreResiduals = false;
        this.caseSensitive = true;
        this.colStats = false;
        this.projectedSchema = null;
        this.selectedColumns = null;
        this.options = ImmutableMap.of();
        this.fromSnapshotId = null;
        this.toSnapshotId = null;
    }

    private TableScanContext(Long snapshotId, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats, Schema projectedSchema, Collection<String> selectedColumns, ImmutableMap<String, String> options, Long fromSnapshotId, Long toSnapshotId) {
        this.snapshotId = snapshotId;
        this.rowFilter = rowFilter;
        this.ignoreResiduals = ignoreResiduals;
        this.caseSensitive = caseSensitive;
        this.colStats = colStats;
        this.projectedSchema = projectedSchema;
        this.selectedColumns = selectedColumns;
        this.options = options;
        this.fromSnapshotId = fromSnapshotId;
        this.toSnapshotId = toSnapshotId;
    }

    Long snapshotId() {
        return this.snapshotId;
    }

    TableScanContext useSnapshotId(Long scanSnapshotId) {
        return new TableScanContext(scanSnapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    Expression rowFilter() {
        return this.rowFilter;
    }

    TableScanContext filterRows(Expression filter) {
        return new TableScanContext(this.snapshotId, filter, this.ignoreResiduals, this.caseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    boolean ignoreResiduals() {
        return this.ignoreResiduals;
    }

    TableScanContext ignoreResiduals(boolean shouldIgnoreResiduals) {
        return new TableScanContext(this.snapshotId, this.rowFilter, shouldIgnoreResiduals, this.caseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    boolean caseSensitive() {
        return this.caseSensitive;
    }

    TableScanContext setCaseSensitive(boolean isCaseSensitive) {
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, isCaseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    boolean returnColumnStats() {
        return this.colStats;
    }

    TableScanContext shouldReturnColumnStats(boolean returnColumnStats) {
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, returnColumnStats, this.projectedSchema, this.selectedColumns, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    Collection<String> selectedColumns() {
        return this.selectedColumns;
    }

    TableScanContext selectColumns(Collection<String> columns) {
        Preconditions.checkState(this.projectedSchema == null, "Cannot select columns when projection schema is set");
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.colStats, null, columns, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    Schema projectedSchema() {
        return this.projectedSchema;
    }

    TableScanContext project(Schema schema) {
        Preconditions.checkState(this.selectedColumns == null, "Cannot set projection schema when columns are selected");
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.colStats, schema, null, this.options, this.fromSnapshotId, this.toSnapshotId);
    }

    Map<String, String> options() {
        return this.options;
    }

    TableScanContext withOption(String property, String value) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.putAll(this.options);
        builder.put(property, value);
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, builder.build(), this.fromSnapshotId, this.toSnapshotId);
    }

    Long fromSnapshotId() {
        return this.fromSnapshotId;
    }

    TableScanContext fromSnapshotId(long id) {
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, this.options, id, this.toSnapshotId);
    }

    Long toSnapshotId() {
        return this.toSnapshotId;
    }

    TableScanContext toSnapshotId(long id) {
        return new TableScanContext(this.snapshotId, this.rowFilter, this.ignoreResiduals, this.caseSensitive, this.colStats, this.projectedSchema, this.selectedColumns, this.options, this.fromSnapshotId, id);
    }
}

