/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Map;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConfig
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    private Map<String, MetricsModes.MetricsMode> columnModes = Maps.newHashMap();
    private MetricsModes.MetricsMode defaultMode;

    private MetricsConfig() {
    }

    public static MetricsConfig getDefault() {
        MetricsConfig spec = new MetricsConfig();
        spec.defaultMode = MetricsModes.fromString("truncate(16)");
        return spec;
    }

    public static MetricsConfig fromProperties(Map<String, String> props) {
        MetricsConfig spec = new MetricsConfig();
        String defaultModeAsString = props.getOrDefault("write.metadata.metrics.default", "truncate(16)");
        try {
            spec.defaultMode = MetricsModes.fromString(defaultModeAsString);
        }
        catch (IllegalArgumentException err) {
            LOG.warn("Ignoring invalid default metrics mode: {}", (Object)defaultModeAsString, (Object)err);
            spec.defaultMode = MetricsModes.fromString("truncate(16)");
        }
        props.keySet().stream().filter(key -> key.startsWith("write.metadata.metrics.column.")).forEach(key -> {
            MetricsModes.MetricsMode mode;
            String columnAlias = key.replaceFirst("write.metadata.metrics.column.", "");
            try {
                mode = MetricsModes.fromString((String)props.get(key));
            }
            catch (IllegalArgumentException err) {
                LOG.warn("Ignoring invalid metrics mode for column {}: {}", new Object[]{columnAlias, props.get(key), err});
                mode = spec.defaultMode;
            }
            spec.columnModes.put(columnAlias, mode);
        });
        return spec;
    }

    public void validateReferencedColumns(Schema schema) {
        for (String column : this.columnModes.keySet()) {
            ValidationException.check(schema.findField(column) != null, "Invalid metrics config, could not find column %s from table prop %s in schema %s", column, "write.metadata.metrics.column." + column, schema);
        }
    }

    public MetricsModes.MetricsMode columnMode(String columnAlias) {
        return this.columnModes.getOrDefault(columnAlias, this.defaultMode);
    }
}

