/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.ImmutableTransplant;
import com.dremio.nessie.model.Validation;
import java.util.List;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;

@Schema(type=SchemaType.OBJECT, title="Transplant")
@JsonSerialize(as=ImmutableTransplant.class)
@JsonDeserialize(as=ImmutableTransplant.class)
@Value.Immutable(prehash=true)
public interface Transplant {
    public List<String> getHashesToTransplant();

    @Value.Check
    default public void checkHashes() {
        List<String> hashes = this.getHashesToTransplant();
        if (hashes != null) {
            for (String hash : hashes) {
                Validation.validateHash(hash);
            }
        }
    }
}

