/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.Reference;
import com.dremio.nessie.model.Tag;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tag", generator="Immutables")
@Immutable
public final class ImmutableTag
implements Tag {
    private final String name;
    @Nullable
    private final String hash;
    private final transient int hashCode;

    private ImmutableTag(String name, @Nullable String hash) {
        this.name = name;
        this.hash = hash;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public String getHash() {
        return this.hash;
    }

    public final ImmutableTag withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableTag.validate(new ImmutableTag(newValue, this.hash));
    }

    public final ImmutableTag withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableTag.validate(new ImmutableTag(this.name, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTag && this.equalTo((ImmutableTag)another);
    }

    private boolean equalTo(ImmutableTag another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && Objects.equals(this.hash, another.hash);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.hash);
        return h2;
    }

    public String toString() {
        return "Tag{name=" + this.name + ", hash=" + this.hash + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTag fromJson(Json json) {
        Builder builder = ImmutableTag.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    private static ImmutableTag validate(ImmutableTag instance) {
        instance.checkName();
        instance.checkHash();
        return instance;
    }

    public static ImmutableTag copyOf(Tag instance) {
        if (instance instanceof ImmutableTag) {
            return (ImmutableTag)instance;
        }
        return ImmutableTag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Tag", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String hash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Tag instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Reference) {
                Reference instance = (Reference)object;
                this.name(instance.getName());
                String hashValue = instance.getHash();
                if (hashValue != null) {
                    this.hash(hashValue);
                }
            }
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        public ImmutableTag build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableTag.validate(new ImmutableTag(this.name, this.hash));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Tag, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Tag", generator="Immutables")
    static final class Json
    implements Tag {
        @Nullable
        String name;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

