/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.NessieConfiguration;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NessieConfiguration", generator="Immutables")
@Immutable
public final class ImmutableNessieConfiguration
extends NessieConfiguration {
    @Nullable
    private final String defaultBranch;
    private final String version;

    private ImmutableNessieConfiguration(Builder builder) {
        this.defaultBranch = builder.defaultBranch;
        this.version = builder.version != null ? builder.version : Objects.requireNonNull(super.getVersion(), "version");
    }

    private ImmutableNessieConfiguration(@Nullable String defaultBranch, String version) {
        this.defaultBranch = defaultBranch;
        this.version = version;
    }

    @Override
    @JsonProperty(value="defaultBranch")
    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public final ImmutableNessieConfiguration withDefaultBranch(@Nullable String value) {
        if (Objects.equals(this.defaultBranch, value)) {
            return this;
        }
        return new ImmutableNessieConfiguration(value, this.version);
    }

    public final ImmutableNessieConfiguration withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNessieConfiguration && this.equalTo((ImmutableNessieConfiguration)another);
    }

    private boolean equalTo(ImmutableNessieConfiguration another) {
        return Objects.equals(this.defaultBranch, another.defaultBranch) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.defaultBranch);
        h2 += (h2 << 5) + this.version.hashCode();
        return h2;
    }

    public String toString() {
        return "NessieConfiguration{defaultBranch=" + this.defaultBranch + ", version=" + this.version + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNessieConfiguration fromJson(Json json) {
        Builder builder = ImmutableNessieConfiguration.builder();
        if (json.defaultBranch != null) {
            builder.defaultBranch(json.defaultBranch);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableNessieConfiguration copyOf(NessieConfiguration instance) {
        if (instance instanceof ImmutableNessieConfiguration) {
            return (ImmutableNessieConfiguration)instance;
        }
        return ImmutableNessieConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NessieConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String defaultBranch;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NessieConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            String defaultBranchValue = instance.getDefaultBranch();
            if (defaultBranchValue != null) {
                this.defaultBranch(defaultBranchValue);
            }
            this.version(instance.getVersion());
            return this;
        }

        @JsonProperty(value="defaultBranch")
        @CanIgnoreReturnValue
        public final Builder defaultBranch(@Nullable String defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        public ImmutableNessieConfiguration build() {
            return new ImmutableNessieConfiguration(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NessieConfiguration", generator="Immutables")
    static final class Json
    extends NessieConfiguration {
        @Nullable
        String defaultBranch;
        @Nullable
        String version;

        Json() {
        }

        @JsonProperty(value="defaultBranch")
        public void setDefaultBranch(@Nullable String defaultBranch) {
            this.defaultBranch = defaultBranch;
        }

        @JsonProperty(value="version")
        public void setVersion(String version) {
            this.version = version;
        }

        @Override
        public String getDefaultBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

