/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.HiveTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HiveTable", generator="Immutables")
@Immutable
public final class ImmutableHiveTable
implements HiveTable {
    private final byte[] tableDefinition;
    private final List<byte[]> partitions;
    private final transient int hashCode;

    private ImmutableHiveTable(byte[] tableDefinition, List<byte[]> partitions) {
        this.tableDefinition = tableDefinition;
        this.partitions = partitions;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="tableDefinition")
    public byte[] getTableDefinition() {
        return (byte[])this.tableDefinition.clone();
    }

    @Override
    @JsonProperty(value="partitions")
    public List<byte[]> getPartitions() {
        return this.partitions;
    }

    public final ImmutableHiveTable withTableDefinition(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableHiveTable(newValue, this.partitions);
    }

    public final ImmutableHiveTable withPartitions(byte[] ... elements) {
        List<byte[]> newValue = ImmutableHiveTable.createUnmodifiableList(false, ImmutableHiveTable.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHiveTable(this.tableDefinition, newValue);
    }

    public final ImmutableHiveTable withPartitions(Iterable<? extends byte[]> elements) {
        if (this.partitions == elements) {
            return this;
        }
        List<byte[]> newValue = ImmutableHiveTable.createUnmodifiableList(false, ImmutableHiveTable.createSafeList(elements, true, false));
        return new ImmutableHiveTable(this.tableDefinition, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHiveTable && this.equalTo((ImmutableHiveTable)another);
    }

    private boolean equalTo(ImmutableHiveTable another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Arrays.equals(this.tableDefinition, another.tableDefinition) && this.partitions.equals(another.partitions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Arrays.hashCode(this.tableDefinition);
        h2 += (h2 << 5) + this.partitions.hashCode();
        return h2;
    }

    public String toString() {
        return "HiveTable{tableDefinition=" + Arrays.toString(this.tableDefinition) + ", partitions=" + this.partitions + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHiveTable fromJson(Json json) {
        Builder builder = ImmutableHiveTable.builder();
        if (json.tableDefinition != null) {
            builder.tableDefinition(json.tableDefinition);
        }
        if (json.partitions != null) {
            builder.addAllPartitions(json.partitions);
        }
        return builder.build();
    }

    public static ImmutableHiveTable copyOf(HiveTable instance) {
        if (instance instanceof ImmutableHiveTable) {
            return (ImmutableHiveTable)instance;
        }
        return ImmutableHiveTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="HiveTable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE_DEFINITION = 1L;
        private long initBits = 1L;
        @Nullable
        private byte[] tableDefinition;
        private List<byte[]> partitions = new ArrayList<byte[]>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HiveTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.tableDefinition(instance.getTableDefinition());
            this.addAllPartitions(instance.getPartitions());
            return this;
        }

        @JsonProperty(value="tableDefinition")
        @CanIgnoreReturnValue
        public final Builder tableDefinition(byte ... tableDefinition) {
            this.tableDefinition = (byte[])tableDefinition.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartitions(byte[] element) {
            this.partitions.add(Objects.requireNonNull(element, "partitions element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPartitions(byte[] ... elements) {
            for (byte[] element : elements) {
                this.partitions.add(Objects.requireNonNull(element, "partitions element"));
            }
            return this;
        }

        @JsonProperty(value="partitions")
        @CanIgnoreReturnValue
        public final Builder partitions(Iterable<? extends byte[]> elements) {
            this.partitions.clear();
            return this.addAllPartitions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPartitions(Iterable<? extends byte[]> elements) {
            for (byte[] byArray : elements) {
                this.partitions.add(Objects.requireNonNull(byArray, "partitions element"));
            }
            return this;
        }

        public ImmutableHiveTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHiveTable(this.tableDefinition, ImmutableHiveTable.createUnmodifiableList(true, this.partitions));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableDefinition");
            }
            return "Cannot build HiveTable, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HiveTable", generator="Immutables")
    static final class Json
    implements HiveTable {
        @Nullable
        byte[] tableDefinition;
        @Nullable
        List<byte[]> partitions = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="tableDefinition")
        public void setTableDefinition(byte[] tableDefinition) {
            this.tableDefinition = tableDefinition;
        }

        @JsonProperty(value="partitions")
        public void setPartitions(List<byte[]> partitions) {
            this.partitions = partitions;
        }

        @Override
        public byte[] getTableDefinition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<byte[]> getPartitions() {
            throw new UnsupportedOperationException();
        }
    }
}

