/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.rest;

import com.dremio.nessie.client.http.ResponseContext;
import com.dremio.nessie.client.http.Status;
import com.dremio.nessie.client.rest.NessieBadRequestException;
import com.dremio.nessie.client.rest.NessieForbiddenException;
import com.dremio.nessie.client.rest.NessieInternalServerException;
import com.dremio.nessie.client.rest.NessieNotAuthorizedException;
import com.dremio.nessie.client.rest.NessieServiceException;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieError;
import com.dremio.nessie.error.NessieNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectReader;

public class ResponseCheckFilter {
    public static void checkResponse(ResponseContext con, ObjectMapper mapper) throws IOException {
        NessieError error;
        Status status = con.getResponseCode();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        try (InputStream is = con.getErrorStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, mapper.readerFor(NessieError.class));
        }
        switch (status) {
            case BAD_REQUEST: {
                throw new NessieBadRequestException(error);
            }
            case UNAUTHORIZED: {
                throw new NessieNotAuthorizedException(error);
            }
            case FORBIDDEN: {
                throw new NessieForbiddenException(error);
            }
            case NOT_FOUND: {
                throw new NessieNotFoundException(error);
            }
            case CONFLICT: {
                throw new NessieConflictException(error);
            }
            case INTERNAL_SERVER_ERROR: {
                throw new NessieInternalServerException(error);
            }
        }
        throw new NessieServiceException(error);
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        NessieError error;
        if (inputStream == null) {
            error = new NessieError(status.getCode(), status.getReason(), "Could not parse error object in response.", new RuntimeException("Could not parse error object in response."));
        } else {
            try {
                error = (NessieError)reader.readValue(inputStream);
            }
            catch (IOException e) {
                error = new NessieError(status.getCode(), status.getReason(), null, e);
            }
        }
        return error;
    }
}

