/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public class ManifestFileUtil {
    private ManifestFileUtil() {
    }

    private static boolean canContain(List<FieldSummary<?>> summaries, StructLike struct) {
        if (struct.size() != summaries.size()) {
            return false;
        }
        for (int pos = 0; pos < summaries.size(); ++pos) {
            Object value = struct.get(pos, Object.class);
            if (summaries.get(pos).canContain(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean canContainAny(ManifestFile manifest, Iterable<StructLike> partitions, Function<Integer, PartitionSpec> specLookup) {
        if (manifest.partitions() == null) {
            return true;
        }
        List<FieldSummary<?>> summaries = ManifestFileUtil.summaries(manifest, specLookup);
        for (StructLike partition : partitions) {
            if (!ManifestFileUtil.canContain(summaries, partition)) continue;
            return true;
        }
        return false;
    }

    public static boolean canContainAny(ManifestFile manifest, Iterable<Pair<Integer, StructLike>> partitions, Map<Integer, PartitionSpec> specsById) {
        if (manifest.partitions() == null) {
            return true;
        }
        List<FieldSummary<?>> summaries = ManifestFileUtil.summaries(manifest, specsById::get);
        for (Pair<Integer, StructLike> partition : partitions) {
            if (partition.first().intValue() != manifest.partitionSpecId() || !ManifestFileUtil.canContain(summaries, partition.second())) continue;
            return true;
        }
        return false;
    }

    private static List<FieldSummary<?>> summaries(ManifestFile manifest, Function<Integer, PartitionSpec> specLookup) {
        Types.StructType partitionType = specLookup.apply(manifest.partitionSpecId()).partitionType();
        List<ManifestFile.PartitionFieldSummary> fieldSummaries = manifest.partitions();
        List<Types.NestedField> fields = partitionType.fields();
        ArrayList<FieldSummary<?>> summaries = Lists.newArrayListWithExpectedSize(fieldSummaries.size());
        for (int pos = 0; pos < fieldSummaries.size(); ++pos) {
            Type.PrimitiveType primitive = fields.get(pos).type().asPrimitiveType();
            summaries.add(new FieldSummary(primitive, fieldSummaries.get(pos)));
        }
        return summaries;
    }

    private static class FieldSummary<T> {
        private final Comparator<T> comparator;
        private final Class<T> javaClass;
        private final T lowerBound;
        private final T upperBound;
        private final boolean containsNull;

        FieldSummary(Type.PrimitiveType primitive, ManifestFile.PartitionFieldSummary summary) {
            this.comparator = Comparators.forType(primitive);
            this.javaClass = primitive.typeId().javaClass();
            this.lowerBound = Conversions.fromByteBuffer(primitive, summary.lowerBound());
            this.upperBound = Conversions.fromByteBuffer(primitive, summary.upperBound());
            this.containsNull = summary.containsNull();
        }

        boolean canContain(Object value) {
            if (value == null) {
                return this.containsNull;
            }
            if (this.lowerBound == null) {
                return false;
            }
            if (!this.javaClass.isInstance(value)) {
                return false;
            }
            T typedValue = this.javaClass.cast(value);
            if (this.comparator.compare(typedValue, this.lowerBound) < 0) {
                return false;
            }
            return this.comparator.compare(typedValue, this.upperBound) <= 0;
        }
    }
}

