/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.shaded.org.apache.parquet.glob.GlobExpander;
import org.apache.iceberg.shaded.org.apache.parquet.glob.WildcardPath;

public final class Strings {
    private Strings() {
    }

    public static String join(Iterable<String> s2, String on) {
        return Strings.join(s2.iterator(), on);
    }

    public static String join(Iterator<String> iter, String on) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(on);
        }
        return sb.toString();
    }

    public static String join(String[] s2, String on) {
        return Strings.join(Arrays.asList(s2), on);
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    public static List<String> expandGlob(String globPattern) {
        return GlobExpander.expand(globPattern);
    }

    public static List<WildcardPath> expandGlobToWildCardPaths(String globPattern, char delim) {
        ArrayList<WildcardPath> ret = new ArrayList<WildcardPath>();
        for (String expandedGlob : Strings.expandGlob(globPattern)) {
            ret.add(new WildcardPath(globPattern, expandedGlob, delim));
        }
        return ret;
    }
}

