/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Types;

class ApplyNameMapping
extends ParquetTypeVisitor<Type> {
    private final NameMapping nameMapping;

    ApplyNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    @Override
    public Type message(MessageType message, List<Type> fields) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        fields.stream().filter(Objects::nonNull).forEach(builder::addField);
        return builder.named(message.getName());
    }

    @Override
    public Type struct(GroupType struct, List<Type> types) {
        MappedField field = this.nameMapping.find(this.currentPath());
        List<Type> actualTypes = types.stream().filter(Objects::nonNull).collect(Collectors.toList());
        GroupType structType = struct.withNewFields(actualTypes);
        return field == null ? structType : ((Type)structType).withId(field.id());
    }

    @Override
    public Type list(GroupType list, Type elementType) {
        Preconditions.checkArgument(elementType != null, "List type must have element field");
        MappedField field = this.nameMapping.find(this.currentPath());
        Type listType = (Type)Types.list(list.getRepetition()).element(elementType).named(list.getName());
        return field == null ? listType : listType.withId(field.id());
    }

    @Override
    public Type map(GroupType map, Type keyType, Type valueType) {
        Preconditions.checkArgument(keyType != null && valueType != null, "Map type must have both key field and value field");
        MappedField field = this.nameMapping.find(this.currentPath());
        Type mapType = (Type)((Types.MapBuilder)((Types.MapBuilder)Types.map(map.getRepetition()).key(keyType)).value(valueType)).named(map.getName());
        return field == null ? mapType : mapType.withId(field.id());
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        MappedField field = this.nameMapping.find(this.currentPath());
        return field == null ? primitive : primitive.withId(field.id());
    }

    @Override
    public void beforeRepeatedElement(Type element) {
    }

    @Override
    public void afterRepeatedElement(Type element) {
    }

    @Override
    public void beforeRepeatedKeyValue(Type keyValue) {
    }

    @Override
    public void afterRepeatedKeyValue(Type keyValue) {
    }
}

