/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Tables;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopTables
implements Tables,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopTables.class);
    private static final String METADATA_JSON = "metadata.json";
    private Configuration conf;

    public HadoopTables() {
        this(new Configuration());
    }

    public HadoopTables(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Table load(String location) {
        Table result;
        Pair<String, MetadataTableType> parsedMetadataType = this.parseMetadataType(location);
        if (parsedMetadataType != null) {
            result = this.loadMetadataTable(parsedMetadataType.first(), location, parsedMetadataType.second());
        } else {
            TableOperations ops = this.newTableOps(location);
            if (ops.current() != null) {
                result = new BaseTable(ops, location);
            } else {
                throw new NoSuchTableException("Table does not exist at location: %s", location);
            }
        }
        LOG.info("Table location loaded: {}", (Object)result.location());
        return result;
    }

    private Pair<String, MetadataTableType> parseMetadataType(String location) {
        int hashIndex = location.lastIndexOf(35);
        if (hashIndex != -1 && !location.endsWith("#")) {
            String baseTable = location.substring(0, hashIndex);
            String metaTable = location.substring(hashIndex + 1);
            MetadataTableType type = MetadataTableType.from(metaTable);
            return type == null ? null : Pair.of(baseTable, type);
        }
        return null;
    }

    private Table loadMetadataTable(String location, String metadataTableName, MetadataTableType type) {
        TableOperations ops = this.newTableOps(location);
        if (ops.current() == null) {
            throw new NoSuchTableException("Table does not exist at location: %s", location);
        }
        return MetadataTableUtils.createMetadataTableInstance(ops, location, metadataTableName, type);
    }

    @Override
    public Table create(Schema schema, PartitionSpec spec, SortOrder order, Map<String, String> properties, String location) {
        Preconditions.checkNotNull(schema, "A table schema is required");
        TableOperations ops = this.newTableOps(location);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table already exists at location: %s", location);
        }
        ImmutableMap<String, String> tableProps = properties == null ? ImmutableMap.of() : properties;
        PartitionSpec partitionSpec = spec == null ? PartitionSpec.unpartitioned() : spec;
        SortOrder sortOrder = order == null ? SortOrder.unsorted() : order;
        TableMetadata metadata = TableMetadata.newTableMetadata(schema, partitionSpec, sortOrder, location, tableProps);
        ops.commit(null, metadata);
        return new BaseTable(ops, location);
    }

    public boolean dropTable(String location) {
        return this.dropTable(location, true);
    }

    public boolean dropTable(String location, boolean purge) {
        TableOperations ops = this.newTableOps(location);
        TableMetadata lastMetadata = null;
        if (ops.current() != null) {
            if (purge) {
                lastMetadata = ops.current();
            }
        } else {
            return false;
        }
        try {
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData(ops.io(), lastMetadata);
            }
            Path tablePath = new Path(location);
            Util.getFs(tablePath, this.conf).delete(tablePath, true);
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file: " + location, e);
        }
    }

    @VisibleForTesting
    TableOperations newTableOps(String location) {
        if (location.contains(METADATA_JSON)) {
            return new StaticTableOperations(location, new HadoopFileIO(this.conf));
        }
        return new HadoopTableOperations(new Path(location), this.conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

