/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;

class ScanContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConfigOption<Long> SNAPSHOT_ID = ConfigOptions.key((String)"snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Boolean> CASE_SENSITIVE = ConfigOptions.key((String)"case-sensitive").booleanType().defaultValue((Object)false);
    private static final ConfigOption<Long> AS_OF_TIMESTAMP = ConfigOptions.key((String)"as-of-timestamp").longType().defaultValue(null);
    private static final ConfigOption<Long> START_SNAPSHOT_ID = ConfigOptions.key((String)"start-snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Long> END_SNAPSHOT_ID = ConfigOptions.key((String)"end-snapshot-id").longType().defaultValue(null);
    private static final ConfigOption<Long> SPLIT_SIZE = ConfigOptions.key((String)"split-size").longType().defaultValue(null);
    private static final ConfigOption<Integer> SPLIT_LOOKBACK = ConfigOptions.key((String)"split-lookback").intType().defaultValue(null);
    private static final ConfigOption<Long> SPLIT_FILE_OPEN_COST = ConfigOptions.key((String)"split-file-open-cost").longType().defaultValue(null);
    private final boolean caseSensitive;
    private final Long snapshotId;
    private final Long startSnapshotId;
    private final Long endSnapshotId;
    private final Long asOfTimestamp;
    private final Long splitSize;
    private final Integer splitLookback;
    private final Long splitOpenFileCost;
    private final String nameMapping;
    private final Schema projectedSchema;
    private final List<Expression> filterExpressions;

    ScanContext() {
        this.caseSensitive = (Boolean)CASE_SENSITIVE.defaultValue();
        this.snapshotId = (Long)SNAPSHOT_ID.defaultValue();
        this.startSnapshotId = (Long)START_SNAPSHOT_ID.defaultValue();
        this.endSnapshotId = (Long)END_SNAPSHOT_ID.defaultValue();
        this.asOfTimestamp = (Long)AS_OF_TIMESTAMP.defaultValue();
        this.splitSize = (Long)SPLIT_SIZE.defaultValue();
        this.splitLookback = (Integer)SPLIT_LOOKBACK.defaultValue();
        this.splitOpenFileCost = (Long)SPLIT_FILE_OPEN_COST.defaultValue();
        this.nameMapping = null;
        this.projectedSchema = null;
        this.filterExpressions = null;
    }

    private ScanContext(boolean caseSensitive, Long snapshotId, Long startSnapshotId, Long endSnapshotId, Long asOfTimestamp, Long splitSize, Integer splitLookback, Long splitOpenFileCost, String nameMapping, Schema projectedSchema, List<Expression> filterExpressions) {
        this.caseSensitive = caseSensitive;
        this.snapshotId = snapshotId;
        this.startSnapshotId = startSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.asOfTimestamp = asOfTimestamp;
        this.splitSize = splitSize;
        this.splitLookback = splitLookback;
        this.splitOpenFileCost = splitOpenFileCost;
        this.nameMapping = nameMapping;
        this.projectedSchema = projectedSchema;
        this.filterExpressions = filterExpressions;
    }

    ScanContext fromProperties(Map<String, String> properties) {
        Configuration config = new Configuration();
        properties.forEach((arg_0, arg_1) -> ((Configuration)config).setString(arg_0, arg_1));
        return new ScanContext((Boolean)config.get(CASE_SENSITIVE), (Long)config.get(SNAPSHOT_ID), (Long)config.get(START_SNAPSHOT_ID), (Long)config.get(END_SNAPSHOT_ID), (Long)config.get(AS_OF_TIMESTAMP), (Long)config.get(SPLIT_SIZE), (Integer)config.get(SPLIT_LOOKBACK), (Long)config.get(SPLIT_FILE_OPEN_COST), properties.get("schema.name-mapping.default"), this.projectedSchema, this.filterExpressions);
    }

    boolean caseSensitive() {
        return this.caseSensitive;
    }

    ScanContext setCaseSensitive(boolean isCaseSensitive) {
        return new ScanContext(isCaseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Long snapshotId() {
        return this.snapshotId;
    }

    ScanContext useSnapshotId(Long scanSnapshotId) {
        return new ScanContext(this.caseSensitive, scanSnapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Long startSnapshotId() {
        return this.startSnapshotId;
    }

    ScanContext startSnapshotId(Long id) {
        return new ScanContext(this.caseSensitive, this.snapshotId, id, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Long endSnapshotId() {
        return this.endSnapshotId;
    }

    ScanContext endSnapshotId(Long id) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, id, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Long asOfTimestamp() {
        return this.asOfTimestamp;
    }

    ScanContext asOfTimestamp(Long timestamp) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, timestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Long splitSize() {
        return this.splitSize;
    }

    ScanContext splitSize(Long size) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, size, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Integer splitLookback() {
        return this.splitLookback;
    }

    ScanContext splitLookback(Integer lookback) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, lookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    Long splitOpenFileCost() {
        return this.splitOpenFileCost;
    }

    ScanContext splitOpenFileCost(Long fileCost) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, fileCost, this.nameMapping, this.projectedSchema, this.filterExpressions);
    }

    String nameMapping() {
        return this.nameMapping;
    }

    ScanContext nameMapping(String mapping) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, mapping, this.projectedSchema, this.filterExpressions);
    }

    Schema projectedSchema() {
        return this.projectedSchema;
    }

    ScanContext project(Schema schema) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, schema, this.filterExpressions);
    }

    List<Expression> filterExpressions() {
        return this.filterExpressions;
    }

    ScanContext filterRows(List<Expression> filters) {
        return new ScanContext(this.caseSensitive, this.snapshotId, this.startSnapshotId, this.endSnapshotId, this.asOfTimestamp, this.splitSize, this.splitLookback, this.splitOpenFileCost, this.nameMapping, this.projectedSchema, filters);
    }
}

