/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.data.FlinkAvroWriter;
import org.apache.iceberg.flink.data.FlinkOrcWriter;
import org.apache.iceberg.flink.data.FlinkParquetWriters;
import org.apache.iceberg.flink.sink.PartitionedFanoutWriter;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.UnpartitionedWriter;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class RowDataTaskWriterFactory
implements TaskWriterFactory<RowData> {
    private final Schema schema;
    private final RowType flinkSchema;
    private final PartitionSpec spec;
    private final LocationProvider locations;
    private final FileIO io;
    private final EncryptionManager encryptionManager;
    private final long targetFileSizeBytes;
    private final FileFormat format;
    private final FileAppenderFactory<RowData> appenderFactory;
    private transient OutputFileFactory outputFileFactory;

    public RowDataTaskWriterFactory(Schema schema, RowType flinkSchema, PartitionSpec spec, LocationProvider locations, FileIO io, EncryptionManager encryptionManager, long targetFileSizeBytes, FileFormat format, Map<String, String> tableProperties) {
        this.schema = schema;
        this.flinkSchema = flinkSchema;
        this.spec = spec;
        this.locations = locations;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.targetFileSizeBytes = targetFileSizeBytes;
        this.format = format;
        this.appenderFactory = new FlinkFileAppenderFactory(schema, flinkSchema, tableProperties);
    }

    @Override
    public void initialize(int taskId, int attemptId) {
        this.outputFileFactory = new OutputFileFactory(this.spec, this.format, this.locations, this.io, this.encryptionManager, taskId, attemptId);
    }

    @Override
    public TaskWriter<RowData> create() {
        Preconditions.checkNotNull(this.outputFileFactory, "The outputFileFactory shouldn't be null if we have invoked the initialize().");
        if (this.spec.fields().isEmpty()) {
            return new UnpartitionedWriter<RowData>(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes);
        }
        return new RowDataPartitionedFanoutWriter(this.spec, this.format, this.appenderFactory, this.outputFileFactory, this.io, this.targetFileSizeBytes, this.schema, this.flinkSchema);
    }

    public static class FlinkFileAppenderFactory
    implements FileAppenderFactory<RowData>,
    Serializable {
        private final Schema schema;
        private final RowType flinkSchema;
        private final Map<String, String> props;

        public FlinkFileAppenderFactory(Schema schema, RowType flinkSchema, Map<String, String> props) {
            this.schema = schema;
            this.flinkSchema = flinkSchema;
            this.props = props;
        }

        @Override
        public FileAppender<RowData> newAppender(OutputFile outputFile, FileFormat format) {
            MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.props);
            try {
                switch (format) {
                    case AVRO: {
                        return Avro.write(outputFile).createWriterFunc(ignore -> new FlinkAvroWriter(this.flinkSchema)).setAll(this.props).schema(this.schema).overwrite().build();
                    }
                    case ORC: {
                        return ORC.write(outputFile).createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(this.flinkSchema, iSchema)).setAll(this.props).schema(this.schema).overwrite().build();
                    }
                    case PARQUET: {
                        return Parquet.write(outputFile).createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)this.flinkSchema, msgType)).setAll(this.props).metricsConfig(metricsConfig).schema(this.schema).overwrite().build();
                    }
                }
                throw new UnsupportedOperationException("Cannot write unknown file format: " + (Object)((Object)format));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class RowDataPartitionedFanoutWriter
    extends PartitionedFanoutWriter<RowData> {
        private final PartitionKey partitionKey;
        private final RowDataWrapper rowDataWrapper;

        RowDataPartitionedFanoutWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<RowData> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, Schema schema, RowType flinkSchema) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
            this.partitionKey = new PartitionKey(spec, schema);
            this.rowDataWrapper = new RowDataWrapper(flinkSchema, schema.asStruct());
        }

        @Override
        protected PartitionKey partition(RowData row) {
            this.partitionKey.partition(this.rowDataWrapper.wrap(row));
            return this.partitionKey;
        }
    }
}

