/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Arrays;
import java.util.Map;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.source.FlinkSource;

public class IcebergTableSource
implements StreamTableSource<RowData>,
ProjectableTableSource<RowData> {
    private final TableLoader loader;
    private final TableSchema schema;
    private final Map<String, String> properties;
    private final int[] projectedFields;

    public IcebergTableSource(TableLoader loader, TableSchema schema, Map<String, String> properties) {
        this(loader, schema, properties, null);
    }

    private IcebergTableSource(TableLoader loader, TableSchema schema, Map<String, String> properties, int[] projectedFields) {
        this.loader = loader;
        this.schema = schema;
        this.properties = properties;
        this.projectedFields = projectedFields;
    }

    public boolean isBounded() {
        return FlinkSource.isBounded(this.properties);
    }

    public TableSource<RowData> projectFields(int[] fields) {
        return new IcebergTableSource(this.loader, this.schema, this.properties, fields);
    }

    public DataStream<RowData> getDataStream(StreamExecutionEnvironment execEnv) {
        return FlinkSource.forRowData().env(execEnv).tableLoader(this.loader).project(this.getProjectedSchema()).properties(this.properties).build();
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public DataType getProducedDataType() {
        return (DataType)this.getProjectedSchema().toRowDataType().bridgedTo(RowData.class);
    }

    private TableSchema getProjectedSchema() {
        TableSchema fullSchema = this.getTableSchema();
        if (this.projectedFields == null) {
            return fullSchema;
        }
        String[] fullNames = fullSchema.getFieldNames();
        DataType[] fullTypes = fullSchema.getFieldDataTypes();
        return TableSchema.builder().fields((String[])Arrays.stream(this.projectedFields).mapToObj(i -> fullNames[i]).toArray(String[]::new), (DataType[])Arrays.stream(this.projectedFields).mapToObj(i -> fullTypes[i]).toArray(DataType[]::new)).build();
    }

    public String explainSource() {
        String explain = "Iceberg table: " + this.loader.toString();
        if (this.projectedFields != null) {
            explain = explain + ", ProjectedFields: " + Arrays.toString(this.projectedFields);
        }
        return TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.getTableSchema().getFieldNames()) + explain;
    }
}

