/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class GenericAppenderFactory
implements FileAppenderFactory<Record> {
    private final Schema schema;
    private final Map<String, String> config = Maps.newHashMap();

    public GenericAppenderFactory(Schema schema) {
        this.schema = schema;
    }

    public GenericAppenderFactory set(String property, String value) {
        this.config.put(property, value);
        return this;
    }

    public GenericAppenderFactory setAll(Map<String, String> properties) {
        this.config.putAll(properties);
        return this;
    }

    @Override
    public FileAppender<Record> newAppender(OutputFile outputFile, FileFormat fileFormat) {
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.config);
        try {
            switch (fileFormat) {
                case AVRO: {
                    return Avro.write(outputFile).schema(this.schema).createWriterFunc(DataWriter::create).setAll(this.config).overwrite().build();
                }
                case PARQUET: {
                    return Parquet.write(outputFile).schema(this.schema).createWriterFunc(GenericParquetWriter::buildWriter).setAll(this.config).metricsConfig(metricsConfig).overwrite().build();
                }
                case ORC: {
                    return ORC.write(outputFile).schema(this.schema).createWriterFunc(GenericOrcWriter::buildWriter).setAll(this.config).overwrite().build();
                }
            }
            throw new UnsupportedOperationException("Cannot write format: " + (Object)((Object)fileFormat));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

